/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StackTraceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StackTraceUtil.class);

    public void printStackTrace(int frameCount) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] elements = thread.getStackTrace();
        int printed = 0;
        for (int i = 2; printed < frameCount && i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            String className = element.getClassName();
            if (className.startsWith("org.springframework.aop") || className.startsWith("org.springframework.cglib.proxy") || element.getMethodName().startsWith("invoke")) continue;
            log.info("{} {} {}", new Object[]{element.getClassName(), element.getMethodName(), element.getLineNumber()});
            ++printed;
        }
    }

    @Generated
    private StackTraceUtil() {
    }
}

