/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.spring;

import com.github.sonus21.rqueue.config.SimpleRqueueListenerContainerFactory;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.producer.RqueueMessageSender;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class RqueueMessageConfig {
    @Autowired(required=false)
    private final SimpleRqueueListenerContainerFactory simpleRqueueListenerContainerFactory = new SimpleRqueueListenerContainerFactory();
    @Autowired
    private BeanFactory beanFactory;

    private RqueueMessageTemplate getMessageTemplate(RedisConnectionFactory connectionFactory) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
        }
        this.simpleRqueueListenerContainerFactory.setRqueueMessageTemplate(new RqueueMessageTemplate(connectionFactory));
        return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
    }

    private RedisConnectionFactory getRedisConnectionFactory() {
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory((RedisConnectionFactory)this.beanFactory.getBean(RedisConnectionFactory.class));
        }
        return this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory();
    }

    @Bean
    public RqueueMessageHandler rqueueMessageHandler() {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler();
        }
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageHandler(this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageHandler();
    }

    @Bean
    public RqueueMessageListenerContainer simpleMessageListenerContainer(RqueueMessageHandler rqueueMessageHandler) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() == null) {
            this.simpleRqueueListenerContainerFactory.setRqueueMessageHandler(rqueueMessageHandler);
        }
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory(this.getRedisConnectionFactory());
        }
        return this.simpleRqueueListenerContainerFactory.createMessageListenerContainer();
    }

    @Bean
    public RqueueMessageSender rqueueMessageSender() {
        return new RqueueMessageSender(this.getMessageTemplate(this.getRedisConnectionFactory()));
    }
}

