/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.spring;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.producer.RqueueMessageSender;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@Configuration
public class RqueueMessageConfig
extends RqueueConfig {
    @Bean
    public RqueueMessageHandler rqueueMessageHandler() {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler();
        }
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageHandler(this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageHandler();
    }

    @Bean
    public RqueueMessageListenerContainer rqueueMessageListenerContainer(RqueueMessageHandler rqueueMessageHandler) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() == null) {
            this.simpleRqueueListenerContainerFactory.setRqueueMessageHandler(rqueueMessageHandler);
        }
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory(this.getRedisConnectionFactory());
        }
        return this.simpleRqueueListenerContainerFactory.createMessageListenerContainer();
    }

    @Bean
    public RqueueMessageSender rqueueMessageSender() {
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageSender(this.getMessageTemplate(this.getRedisConnectionFactory()), this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageSender(this.getMessageTemplate(this.getRedisConnectionFactory()));
    }

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer() {
        RedisMessageListenerContainer messageListenerContainer = new RedisMessageListenerContainer();
        messageListenerContainer.setConnectionFactory(this.getRedisConnectionFactory());
        return messageListenerContainer;
    }
}

