/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.spring;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueListenerBaseConfig;
import com.github.sonus21.rqueue.core.RqueueEndpointManager;
import com.github.sonus21.rqueue.core.RqueueMessageEnqueuer;
import com.github.sonus21.rqueue.core.RqueueMessageManager;
import com.github.sonus21.rqueue.core.RqueueMessageSender;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.RqueueEndpointManagerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueMessageEnqueuerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueMessageManagerImpl;
import com.github.sonus21.rqueue.core.impl.RqueueMessageSenderImpl;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.metrics.QueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetrics;
import com.github.sonus21.rqueue.metrics.RqueueMetricsCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetricsRegistry;
import com.github.sonus21.rqueue.spring.MetricsEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ComponentScan(value={"com.github.sonus21.rqueue.web"})
public class RqueueListenerConfig
extends RqueueListenerBaseConfig {
    @Bean
    public RqueueMessageHandler rqueueMessageHandler() {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler();
        }
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageHandler(this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageHandler();
    }

    @Bean
    @DependsOn(value={"rqueueConfig"})
    public RqueueMessageListenerContainer rqueueMessageListenerContainer(RqueueMessageHandler rqueueMessageHandler) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageHandler() == null) {
            this.simpleRqueueListenerContainerFactory.setRqueueMessageHandler(rqueueMessageHandler);
        }
        return this.simpleRqueueListenerContainerFactory.createMessageListenerContainer();
    }

    @Bean
    public RqueueMessageTemplate rqueueMessageTemplate(RqueueConfig rqueueConfig) {
        return this.getMessageTemplate(rqueueConfig);
    }

    @Bean
    public RqueueMessageSender rqueueMessageSender(RqueueMessageTemplate rqueueMessageTemplate) {
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageSenderImpl(rqueueMessageTemplate, this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageSenderImpl(rqueueMessageTemplate);
    }

    @Bean
    public RqueueMessageManager rqueueMessageManager(RqueueMessageTemplate rqueueMessageTemplate) {
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageManagerImpl(rqueueMessageTemplate, this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageManagerImpl(rqueueMessageTemplate);
    }

    @Bean
    public RqueueEndpointManager rqueueEndpointManager(RqueueMessageTemplate rqueueMessageTemplate) {
        return new RqueueEndpointManagerImpl(rqueueMessageTemplate);
    }

    @Bean
    public RqueueMessageEnqueuer rqueueMessageEnqueuer(RqueueMessageTemplate rqueueMessageTemplate) {
        if (this.simpleRqueueListenerContainerFactory.getMessageConverters() != null) {
            return new RqueueMessageEnqueuerImpl(rqueueMessageTemplate, this.simpleRqueueListenerContainerFactory.getMessageConverters());
        }
        return new RqueueMessageEnqueuerImpl(rqueueMessageTemplate);
    }

    @Bean
    @Conditional(value={MetricsEnabled.class})
    @DependsOn(value={"meterRegistry", "rqueueMetricsProperties"})
    public RqueueMetricsRegistry rqueueMetricsRegistry(@Qualifier(value="stringRqueueRedisTemplate") RqueueRedisTemplate<String> rqueueRedisTemplate) {
        QueueCounter queueCounter = new QueueCounter();
        return new RqueueMetrics(rqueueRedisTemplate, queueCounter);
    }

    @Bean
    @Conditional(value={MetricsEnabled.class})
    public RqueueMetricsCounter rqueueMetricsCounter(RqueueMetricsRegistry rqueueMetricsRegistry) {
        return new RqueueCounter(rqueueMetricsRegistry.getQueueCounter());
    }
}

