/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.StringMessageTemplate;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import java.util.List;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class SimpleRqueueListenerContainerFactory {
    private AsyncTaskExecutor taskExecutor;
    private boolean autoStartup = true;
    private RqueueMessageTemplate rqueueMessageTemplate;
    private RedisConnectionFactory redisConnectionFactory;
    private RqueueMessageHandler rqueueMessageHandler;
    private StringMessageTemplate stringMessageTemplate;
    private List<MessageConverter> messageConverters;
    private Long backOffTime;
    private Integer maxNumWorkers;

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"taskExecutor can not be null");
        this.taskExecutor = taskExecutor;
    }

    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setRqueueMessageHandler(RqueueMessageHandler rqueueMessageHandler) {
        Assert.notNull((Object)((Object)rqueueMessageHandler), (String)"rqueueMessageHandler must not be null");
        this.rqueueMessageHandler = rqueueMessageHandler;
    }

    public RqueueMessageHandler getRqueueMessageHandler() {
        return this.rqueueMessageHandler;
    }

    public Long getBackOffTime() {
        return this.backOffTime;
    }

    public void setBackOffTime(long backOffTime) {
        this.backOffTime = backOffTime;
    }

    public void setMaxNumWorkers(int maxNumWorkers) {
        this.maxNumWorkers = maxNumWorkers;
    }

    public Integer getMaxNumWorkers() {
        return this.maxNumWorkers;
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"messageConverters must not be empty");
        this.messageConverters = messageConverters;
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageConverters;
    }

    public void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        Assert.notNull((Object)redisConnectionFactory, (String)"redisConnectionFactory must not be null");
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public void setRqueueMessageTemplate(RqueueMessageTemplate messageTemplate) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate must not be null");
        this.rqueueMessageTemplate = messageTemplate;
    }

    public RqueueMessageTemplate getRqueueMessageTemplate() {
        return this.rqueueMessageTemplate;
    }

    public RqueueMessageListenerContainer createMessageListenerContainer() {
        Assert.notNull((Object)((Object)this.rqueueMessageHandler), (String)"rqueueMessageHandler must not be null");
        Assert.notNull((Object)this.redisConnectionFactory, (String)"redisConnectionFactory must not be null");
        if (this.rqueueMessageTemplate == null) {
            this.rqueueMessageTemplate = new RqueueMessageTemplate(this.redisConnectionFactory);
        }
        if (this.stringMessageTemplate == null) {
            this.stringMessageTemplate = new StringMessageTemplate(this.redisConnectionFactory);
        }
        RqueueMessageListenerContainer messageListenerContainer = new RqueueMessageListenerContainer(this.rqueueMessageHandler, this.rqueueMessageTemplate, this.stringMessageTemplate);
        messageListenerContainer.setAutoStartup(this.autoStartup);
        if (this.taskExecutor != null) {
            messageListenerContainer.setTaskExecutor(this.taskExecutor);
        }
        if (this.maxNumWorkers != null) {
            messageListenerContainer.setMaxNumWorkers(this.maxNumWorkers);
        }
        if (this.backOffTime != null) {
            messageListenerContainer.setBackOffTime(this.backOffTime);
        }
        return messageListenerContainer;
    }
}

