/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.StringMessageTemplate;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

public class LockManager {
    private StringMessageTemplate stringMessageTemplate;
    private static final long LOCK_EXPIRY_TIME = 10L;

    public LockManager(StringMessageTemplate stringMessageTemplate) {
        Assert.notNull((Object)stringMessageTemplate, (String)"stringMessageTemplate can not be null");
        this.stringMessageTemplate = stringMessageTemplate;
    }

    public boolean acquireLock(String lock) {
        try {
            return this.stringMessageTemplate.putIfAbsent(lock, 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void releaseLock(String lock) {
        this.stringMessageTemplate.delete(lock);
    }
}

