/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueRedisTemplate;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.CollectionUtils;

public class RqueueMessageTemplate
extends RqueueRedisTemplate<String, RqueueMessage> {
    private static final long KEY_POP_TIMEOUT = 10L;

    public RqueueMessageTemplate(RedisConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
    }

    public void add(String key, RqueueMessage message) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)message);
    }

    public RqueueMessage lpop(String key) {
        return (RqueueMessage)this.redisTemplate.opsForList().leftPop((Object)key, 10L, TimeUnit.SECONDS);
    }

    public void addToZset(String key, RqueueMessage rqueueMessage) {
        this.redisTemplate.opsForZSet().add((Object)key, (Object)rqueueMessage, (double)rqueueMessage.getProcessAt());
    }

    public void removeFromZset(String key, RqueueMessage rqueueMessage) {
        this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{rqueueMessage});
    }

    public RqueueMessage getFirstFromZset(String key) {
        Set msgs = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, 0L, 0L);
        if (CollectionUtils.isEmpty((Collection)msgs)) {
            return null;
        }
        return (RqueueMessage)((ZSetOperations.TypedTuple)msgs.stream().findFirst().get()).getValue();
    }
}

