/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.utils.Constants;
import java.util.Collections;
import java.util.Map;

class ConsumerQueueDetail {
    private final String queueName;
    private final boolean delayedQueue;
    private final String dlqName;
    private final int numRetries;
    private final String zsetName;

    ConsumerQueueDetail(String queueName, int numRetries, String deadLaterQueueName, boolean delayedQueue) {
        this.queueName = queueName;
        this.numRetries = numRetries;
        this.delayedQueue = delayedQueue;
        this.dlqName = deadLaterQueueName;
        this.zsetName = delayedQueue ? Constants.getZsetName(queueName) : null;
    }

    Map<String, Object> getHeaders() {
        return Collections.singletonMap("QUEUE_NAME", this.queueName);
    }

    String getQueueName() {
        return this.queueName;
    }

    boolean isDelayedQueue() {
        return this.delayedQueue;
    }

    String getDlqName() {
        return this.dlqName;
    }

    int getNumRetries() {
        return this.numRetries;
    }

    String getZsetName() {
        return this.zsetName;
    }
}

