/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageHandler;
import org.slf4j.Logger;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;

class MessageExecutor
implements Runnable {
    private final ConsumerQueueDetail queueDetail;
    private final Message<String> message;
    private final RqueueMessage rqueueMessage;
    private final RqueueMessageHandler messageHandler;
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final Logger logger;

    MessageExecutor(RqueueMessage message, ConsumerQueueDetail queueDetail, RqueueMessageHandler messageHandler, RqueueMessageTemplate rqueueMessageTemplate, Logger logger) {
        message.updateAccessTime();
        this.rqueueMessage = message;
        this.queueDetail = queueDetail;
        this.message = new GenericMessage((Object)message.getMessage(), queueDetail.getHeaders());
        this.messageHandler = messageHandler;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.logger = logger;
    }

    @Override
    public void run() {
        int retryCount = this.rqueueMessage.getRetryCount() == null ? this.queueDetail.getNumRetries() : this.rqueueMessage.getRetryCount().intValue();
        boolean executed = false;
        if (retryCount == -1 && this.queueDetail.getDlqName().isEmpty()) {
            retryCount = Integer.MAX_VALUE;
        }
        do {
            try {
                this.messageHandler.handleMessage(this.message);
                executed = true;
            }
            catch (Exception e) {
                this.logger.warn("Message '{}' is failing", this.message.getPayload(), (Object)e);
                --retryCount;
            }
        } while (retryCount > 0 && !executed);
        if (!executed) {
            if (this.queueDetail.getDlqName().isEmpty()) {
                this.logger.warn("Message '{}' discarded, queue: {}", this.message.getPayload(), (Object)this.queueDetail.getQueueName());
            } else {
                this.rqueueMessage.updateReEnqueuedAt();
                this.rqueueMessageTemplate.add(this.queueDetail.getDlqName(), this.rqueueMessage);
            }
        }
    }
}

