/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.config.SimpleRqueueListenerContainerFactory;
import com.github.sonus21.rqueue.core.DelayedMessageScheduler;
import com.github.sonus21.rqueue.core.ProcessingMessageScheduler;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.utils.RedisUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public abstract class RqueueConfig {
    @Autowired(required=false)
    protected final SimpleRqueueListenerContainerFactory simpleRqueueListenerContainerFactory = new SimpleRqueueListenerContainerFactory();
    @Autowired
    protected BeanFactory beanFactory;
    @Value(value="${auto.start.scheduler:true}")
    private boolean autoStartScheduler;
    @Value(value="${delayed.queue.thread.pool.size:5}")
    private int delayedQueueSchedulerPoolSize;
    @Value(value="${processing.queue.thread.pool.size:1}")
    private int processingQueueSchedulerPoolSize;

    protected RedisConnectionFactory getRedisConnectionFactory() {
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory((RedisConnectionFactory)this.beanFactory.getBean(RedisConnectionFactory.class));
        }
        return this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory();
    }

    protected RqueueMessageTemplate getMessageTemplate(RedisConnectionFactory connectionFactory) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
        }
        this.simpleRqueueListenerContainerFactory.setRqueueMessageTemplate(new RqueueMessageTemplate(connectionFactory));
        return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
    }

    @Bean
    public DelayedMessageScheduler delayedMessageScheduler() {
        return new DelayedMessageScheduler(RedisUtil.getRedisTemplate(this.getRedisConnectionFactory()), this.delayedQueueSchedulerPoolSize, this.autoStartScheduler);
    }

    @Bean
    public ProcessingMessageScheduler processingMessageScheduler() {
        return new ProcessingMessageScheduler(RedisUtil.getRedisTemplate(this.getRedisConnectionFactory()), this.processingQueueSchedulerPoolSize, this.autoStartScheduler);
    }
}

