/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.MessageScheduler;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.utils.QueueInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class ProcessingMessageScheduler
extends MessageScheduler {
    private final Logger logger = LoggerFactory.getLogger(ProcessingMessageScheduler.class);

    public ProcessingMessageScheduler(RedisTemplate<String, Long> redisTemplate, int poolSize, boolean scheduleTaskAtStartup) {
        super(redisTemplate, poolSize, scheduleTaskAtStartup);
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    protected String getChannelName(String queueName) {
        return QueueInfo.getProcessingQueueChannelName(queueName);
    }

    @Override
    protected String getZsetName(String queueName) {
        return QueueInfo.getProcessingQueueName(queueName);
    }

    @Override
    protected boolean isQueueValid(ConsumerQueueDetail queueDetail) {
        return true;
    }

    @Override
    protected String getThreadNamePrefix() {
        return "RQProcessing-";
    }

    @Override
    protected long getNextScheduleTime(long currentTime, Long value) {
        if (value == null) {
            return QueueInfo.getMessageReEnqueueTime(currentTime);
        }
        return Long.max(currentTime, value);
    }
}

