/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RqueueMessage
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3488860960637488519L;
    private String id;
    private String queueName;
    private String message;
    private Integer retryCount;
    private long queuedTime;
    private long processAt;
    private Long reEnqueuedAt;
    private int failureCount;

    public RqueueMessage() {
    }

    public RqueueMessage(String queueName, String message, Integer retryCount, Long delay) {
        this.queueName = queueName;
        this.message = message;
        this.retryCount = retryCount;
        this.queuedTime = System.currentTimeMillis();
        this.id = queueName + UUID.randomUUID().toString();
        if (delay != null) {
            this.processAt = this.queuedTime + delay;
        }
    }

    public void updateReEnqueuedAt() {
        this.reEnqueuedAt = System.currentTimeMillis();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public long getQueuedTime() {
        return this.queuedTime;
    }

    public void setQueuedTime(long queuedTime) {
        this.queuedTime = queuedTime;
    }

    public long getProcessAt() {
        return this.processAt;
    }

    public void setProcessAt(Long processAt) {
        this.processAt = processAt;
    }

    public Long getReEnqueuedAt() {
        return this.reEnqueuedAt;
    }

    public void setReEnqueuedAt(Long reEnqueuedAt) {
        this.reEnqueuedAt = reEnqueuedAt;
    }

    public String toString() {
        return "RqueueMessage(id=" + this.getId() + ", queueName=" + this.getQueueName() + ", message=" + this.getMessage() + ", retryCount=" + this.getRetryCount() + ", queuedTime=" + this.getQueuedTime() + ", processAt=" + this.getProcessAt() + ", reEnqueuedAt=" + this.getReEnqueuedAt() + ", failureCount=" + this.getFailureCount() + ")";
    }

    public RqueueMessage clone() throws CloneNotSupportedException {
        return (RqueueMessage)super.clone();
    }

    public boolean equals(Object other) {
        RqueueMessage otherMessage;
        if (other instanceof RqueueMessage && (otherMessage = (RqueueMessage)other).getId() != null && this.getId() != null) {
            return this.getId().equals(otherMessage.getId());
        }
        return false;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

