/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.utils.QueueInfo;
import com.github.sonus21.rqueue.utils.RqueueRedisTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;

public class RqueueMessageTemplate
extends RqueueRedisTemplate<RqueueMessage> {
    private static final int MESSAGE_BATCH_SIZE = 100;
    private DefaultScriptExecutor<String> scriptExecutor;

    public RqueueMessageTemplate(RedisConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
        this.scriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
    }

    public void add(String queueName, RqueueMessage message) {
        this.redisTemplate.opsForList().rightPush((Object)queueName, (Object)message);
    }

    public RqueueMessage pop(String queueName) {
        long currentTime = System.currentTimeMillis();
        RedisScript<?> script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.REMOVE_MESSAGE);
        return (RqueueMessage)this.scriptExecutor.execute(script, Arrays.asList(queueName, QueueInfo.getProcessingQueueName(queueName), QueueInfo.getProcessingQueueChannelName(queueName)), new Object[]{currentTime, QueueInfo.getMessageReEnqueueTime(currentTime)});
    }

    public void addWithDelay(String queueName, RqueueMessage rqueueMessage) {
        long queuedTime = rqueueMessage.getQueuedTime();
        RedisScript<?> script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.ADD_MESSAGE);
        this.scriptExecutor.execute(script, Arrays.asList(QueueInfo.getTimeQueueName(queueName), QueueInfo.getChannelName(queueName)), new Object[]{rqueueMessage, rqueueMessage.getProcessAt(), queuedTime});
    }

    public void removeFromZset(String zsetName, RqueueMessage rqueueMessage) {
        this.redisTemplate.opsForZSet().remove((Object)zsetName, new Object[]{rqueueMessage});
    }

    public void replaceMessage(String zsetName, RqueueMessage src, RqueueMessage tgt) {
        RedisScript<?> script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.REPLACE_MESSAGE);
        this.scriptExecutor.execute(script, Collections.singletonList(zsetName), new Object[]{src, tgt});
    }

    public List<RqueueMessage> getAllMessages(String queueName) {
        Set messagesInProcessingQueue;
        Set messagesFromZset;
        ArrayList<RqueueMessage> messages = this.redisTemplate.opsForList().range((Object)queueName, 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)messages)) {
            messages = new ArrayList<RqueueMessage>();
        }
        if (!CollectionUtils.isEmpty((Collection)(messagesFromZset = this.redisTemplate.opsForZSet().range((Object)QueueInfo.getTimeQueueName(queueName), 0L, -1L)))) {
            messages.addAll(messagesFromZset);
        }
        if (!CollectionUtils.isEmpty((Collection)(messagesInProcessingQueue = this.redisTemplate.opsForZSet().range((Object)QueueInfo.getProcessingQueueName(queueName), 0L, -1L)))) {
            messages.addAll(messagesInProcessingQueue);
        }
        return messages;
    }

    public Long getListLength(String lName) {
        return this.redisTemplate.opsForList().size((Object)lName);
    }

    public Long getZsetSize(String zsetName) {
        return this.redisTemplate.opsForZSet().size((Object)zsetName);
    }

    public boolean moveMessage(String srcQueueName, String dstQueueName, int maxMessage) {
        long remainingMessages;
        RedisScript<?> script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE);
        for (int offset = 100; (remainingMessages = ((Long)this.scriptExecutor.execute(script, Arrays.asList(srcQueueName, dstQueueName), new Object[]{100})).longValue()) > 0L && offset < maxMessage; offset += 100) {
        }
        return true;
    }
}

