/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.metrics.RqueueMetricsProperties;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;

public class RqueueCounter {
    private static final String FAILURE_COUNT = "failure.count";
    private static final String EXECUTION_COUNT = "execution.count";
    private Map<String, Counter> queueNameToFailureCounter = new HashMap<String, Counter>();
    private Map<String, Counter> queueNameToExecutionCounter = new HashMap<String, Counter>();

    private void updateCounter(Map<String, Counter> map, String queueName) {
        Counter counter = map.get(queueName);
        if (counter == null) {
            return;
        }
        counter.increment();
    }

    public void updateFailureCount(String queueName) {
        this.updateCounter(this.queueNameToFailureCounter, queueName);
    }

    public void updateExecutionCount(String queueName) {
        this.updateCounter(this.queueNameToExecutionCounter, queueName);
    }

    void registerQueue(RqueueMetricsProperties metricsProperties, Tags queueTags, MeterRegistry registry, String queueName) {
        Counter counter;
        Counter.Builder builder;
        if (metricsProperties.countFailure()) {
            builder = Counter.builder((String)FAILURE_COUNT).tags((Iterable)queueTags).description("Failure count");
            counter = builder.register(registry);
            this.queueNameToFailureCounter.put(queueName, counter);
        }
        if (metricsProperties.countExecution()) {
            builder = Counter.builder((String)EXECUTION_COUNT).tags((Iterable)queueTags).description("Task execution count");
            counter = builder.register(registry);
            this.queueNameToExecutionCounter.put(queueName, counter);
        }
    }
}

