/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.metrics.RqueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetricsProperties;
import com.github.sonus21.rqueue.utils.QueueInfo;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.ref.WeakReference;

public class RqueueMetrics
implements MeterBinder {
    private static final String QUEUE_SIZE = "queue.size";
    private static final String DELAYED_QUEUE_SIZE = "delayed.queue.size";
    private static final String PROCESSING_QUEUE_SIZE = "processing.queue.size";
    private static final String DEAD_LETTER_QUEUE_SIZE = "dead.letter.queue.size";
    private RqueueCounter rqueueCounter;
    private WeakReference<RqueueMessageListenerContainer> container;
    private RqueueMetricsProperties metricsProperties;

    public RqueueMetrics(RqueueMessageListenerContainer container, RqueueMetricsProperties metricsProperties, RqueueCounter counter) {
        this.metricsProperties = metricsProperties;
        this.rqueueCounter = counter;
        this.container = new WeakReference<RqueueMessageListenerContainer>(container);
    }

    public static RqueueMetrics monitor(RqueueMessageListenerContainer container, MeterRegistry registry, RqueueMetricsProperties metricsProperties, RqueueCounter counter) {
        if (container == null) {
            return null;
        }
        RqueueMetrics rqueueMetrics = new RqueueMetrics(container, metricsProperties, counter);
        rqueueMetrics.bindTo(registry);
        return rqueueMetrics;
    }

    private int numQueues() {
        RqueueMessageListenerContainer listenerContainer = (RqueueMessageListenerContainer)this.container.get();
        if (listenerContainer == null) {
            return 0;
        }
        return listenerContainer.getRegisteredQueues().size();
    }

    private long size(String name, boolean isZset) {
        Long val = !isZset ? ((RqueueMessageListenerContainer)this.container.get()).getRqueueMessageTemplate().getListLength(name) : ((RqueueMessageListenerContainer)this.container.get()).getRqueueMessageTemplate().getZsetSize(name);
        if (val == null || val < 0L) {
            return 0L;
        }
        return val;
    }

    public void bindTo(MeterRegistry registry) {
        if (this.numQueues() == 0) {
            return;
        }
        for (ConsumerQueueDetail queueDetail : ((RqueueMessageListenerContainer)this.container.get()).getRegisteredQueues().values()) {
            Tags queueTags = Tags.concat((Iterable)this.metricsProperties.getMetricTags(), (String[])new String[]{"queue", queueDetail.getQueueName()});
            Gauge.builder((String)QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getQueueName(), false)).tags((Iterable)queueTags).description("The number of entries in this queue").register(registry);
            Gauge.builder((String)PROCESSING_QUEUE_SIZE, (Object)queueDetail, c -> this.size(QueueInfo.getProcessingQueueName(queueDetail.getQueueName()), true)).tags((Iterable)queueTags).description("The number of entries in the processing queue").register(registry);
            if (queueDetail.isDelayedQueue()) {
                Gauge.builder((String)DELAYED_QUEUE_SIZE, (Object)queueDetail, c -> this.size(QueueInfo.getTimeQueueName(queueDetail.getQueueName()), true)).tags((Iterable)queueTags).description("The number of entries waiting in the delayed queue").register(registry);
            }
            if (queueDetail.isDlqSet()) {
                Gauge.Builder builder = Gauge.builder((String)DEAD_LETTER_QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getDlqName(), false));
                builder.tags((Iterable)queueTags);
                builder.description("The number of entries in the dead letter queue");
                builder.register(registry);
            }
            if (this.rqueueCounter == null) continue;
            this.rqueueCounter.registerQueue(this.metricsProperties, queueTags, registry, queueDetail.getQueueName());
        }
    }
}

