/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.MessageScheduler;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.utils.QueueInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class DelayedMessageScheduler
extends MessageScheduler {
    private static final long DEFAULT_DELAY = 5000L;
    private final Logger logger = LoggerFactory.getLogger(DelayedMessageScheduler.class);

    public DelayedMessageScheduler(RedisTemplate<String, Long> redisTemplate, int poolSize, boolean scheduleTaskAtStartup) {
        super(redisTemplate, poolSize, scheduleTaskAtStartup);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    protected long getNextScheduleTime(long currentTime, Long value) {
        if (value == null) {
            return currentTime + 5000L;
        }
        if (value < currentTime) {
            return currentTime;
        }
        return currentTime + 5000L;
    }

    @Override
    protected String getChannelName(String queueName) {
        return QueueInfo.getChannelName(queueName);
    }

    @Override
    protected String getZsetName(String queueName) {
        return QueueInfo.getTimeQueueName(queueName);
    }

    @Override
    protected String getThreadNamePrefix() {
        return "RQDelayed-";
    }

    @Override
    protected boolean isQueueValid(ConsumerQueueDetail queueDetail) {
        return queueDetail.isDelayedQueue();
    }
}

