/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.core.ScheduledTaskDetail;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.utils.QueueInitializationEvent;
import com.github.sonus21.rqueue.utils.SchedulerFactory;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class MessageScheduler
implements DisposableBean,
ApplicationListener<QueueInitializationEvent> {
    private static final long DEFAULT_SCRIPT_EXECUTION_TIME = 5000L;
    private static final long MIN_DELAY = 10L;
    private static final int MAX_MESSAGE = 100;
    private static final long TASK_ALIVE_TIME = -30000L;
    private final int poolSize;
    private boolean scheduleTaskAtStartup;
    private RedisScript<Long> redisScript;
    private MessageSchedulerListener messageSchedulerListener;
    private RedisTemplate<String, Long> redisTemplate;
    private DefaultScriptExecutor<String> defaultScriptExecutor;
    private Map<String, Boolean> queueRunningState;
    private Map<String, ScheduledTaskDetail> queueNameToScheduledTask;
    private Map<String, String> channelNameToQueueName;
    private Map<String, String> queueNameToZsetName;
    private Map<String, Long> queueNameToLastMessageSeenTime;
    private ThreadPoolTaskScheduler scheduler;
    @Autowired
    private RedisMessageListenerContainer redisMessageListenerContainer;

    public MessageScheduler(RedisTemplate<String, Long> redisTemplate, int poolSize, boolean scheduleTaskAtStartup) {
        this.poolSize = poolSize;
        this.scheduleTaskAtStartup = scheduleTaskAtStartup;
        this.redisTemplate = redisTemplate;
    }

    protected abstract Logger getLogger();

    protected abstract long getNextScheduleTime(long var1, Long var3);

    protected abstract String getChannelName(String var1);

    protected abstract String getZsetName(String var1);

    protected abstract String getThreadNamePrefix();

    protected abstract boolean isQueueValid(ConsumerQueueDetail var1);

    private void doStart() {
        for (String queueName : this.queueRunningState.keySet()) {
            this.startQueue(queueName);
        }
    }

    private void startQueue(String queueName) {
        if (Boolean.TRUE.equals(this.queueRunningState.get(queueName))) {
            return;
        }
        this.queueRunningState.put(queueName, true);
        if (this.isScheduleTaskAtStartup()) {
            long scheduleAt = System.currentTimeMillis() + 10L;
            this.schedule(queueName, this.getZsetName(queueName), scheduleAt, false);
        }
        this.redisMessageListenerContainer.addMessageListener((MessageListener)this.messageSchedulerListener, (Topic)new ChannelTopic(this.getChannelName(queueName)));
        this.channelNameToQueueName.put(this.getChannelName(queueName), queueName);
        this.queueNameToZsetName.put(queueName, this.getZsetName(queueName));
    }

    private void doStop() {
        if (CollectionUtils.isEmpty(this.queueRunningState)) {
            return;
        }
        for (Map.Entry<String, Boolean> runningStateByQueue : this.queueRunningState.entrySet()) {
            if (!Boolean.TRUE.equals(runningStateByQueue.getValue())) continue;
            this.stopQueue(runningStateByQueue.getKey());
        }
        this.waitForRunningQueuesToStop();
        this.queueNameToScheduledTask.clear();
    }

    private void waitForRunningQueuesToStop() {
        for (Map.Entry<String, Boolean> runningState : this.queueRunningState.entrySet()) {
            Future<?> future;
            boolean completedOrCancelled;
            String queueName = runningState.getKey();
            ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
            if (scheduledTaskDetail == null || (completedOrCancelled = (future = scheduledTaskDetail.getFuture()).isCancelled() || future.isDone())) continue;
            scheduledTaskDetail.getFuture().cancel(true);
        }
    }

    private void stopQueue(String queueName) {
        Assert.isTrue((boolean)this.queueRunningState.containsKey(queueName), (String)("Queue with name '" + queueName + "' does not exist"));
        this.queueRunningState.put(queueName, false);
    }

    private boolean isScheduleTaskAtStartup() {
        return this.scheduleTaskAtStartup;
    }

    public void destroy() throws Exception {
        this.doStop();
        if (this.scheduler != null) {
            this.scheduler.destroy();
        }
    }

    private void createScheduler(int queueCount) {
        if (queueCount == 0) {
            return;
        }
        this.scheduler = SchedulerFactory.createThreadPoolTaskScheduler(Math.min(this.poolSize, queueCount), this.getThreadNamePrefix(), 60);
    }

    private boolean isQueueActive(String queueName) {
        Boolean val = this.queueRunningState.get(queueName);
        if (val == null) {
            return false;
        }
        return val;
    }

    protected synchronized void schedule(String queueName, String zsetName, Long startTime, boolean forceSchedule) {
        boolean completedOrCancelled;
        boolean isQueueActive = this.isQueueActive(queueName);
        if (!isQueueActive || this.scheduler == null) {
            return;
        }
        long lastSeenTime = this.queueNameToLastMessageSeenTime.getOrDefault(queueName, 0L);
        long currentTime = System.currentTimeMillis();
        if (!forceSchedule && currentTime - lastSeenTime < 10L) {
            return;
        }
        this.queueNameToLastMessageSeenTime.put(queueName, currentTime);
        ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
        if (scheduledTaskDetail == null || forceSchedule) {
            Future future;
            long requiredDelay = Math.max(1L, startTime - currentTime);
            long taskStartTime = startTime;
            MessageMoverTask timerTask = new MessageMoverTask(queueName, zsetName);
            if (requiredDelay < 10L) {
                future = this.scheduler.submit((Runnable)timerTask);
                taskStartTime = currentTime;
            } else {
                future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(currentTime + requiredDelay));
            }
            scheduledTaskDetail = new ScheduledTaskDetail(taskStartTime, future);
            this.queueNameToScheduledTask.put(timerTask.getQueueName(), scheduledTaskDetail);
            return;
        }
        long existingDelay = scheduledTaskDetail.getStartTime() - currentTime;
        Future<?> submittedTask = scheduledTaskDetail.getFuture();
        boolean bl = completedOrCancelled = submittedTask.isDone() || submittedTask.isCancelled();
        if (!completedOrCancelled && existingDelay < 10L && existingDelay > -30000L) {
            try {
                submittedTask.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                this.getLogger().debug("{} task failed", (Object)scheduledTaskDetail, (Object)e);
            }
        }
        MessageMoverTask timerTask = new MessageMoverTask(queueName, zsetName);
        ScheduledFuture future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(this.getNextScheduleTime(System.currentTimeMillis(), startTime)));
        this.queueNameToScheduledTask.put(timerTask.getQueueName(), new ScheduledTaskDetail(startTime, future));
    }

    private void initialize(Map<String, ConsumerQueueDetail> queueDetailMap) {
        HashSet<String> queueNames = new HashSet<String>();
        for (Map.Entry<String, ConsumerQueueDetail> entry : queueDetailMap.entrySet()) {
            String queueName = entry.getKey();
            ConsumerQueueDetail queueDetail = entry.getValue();
            if (!this.isQueueValid(queueDetail)) continue;
            queueNames.add(queueName);
        }
        this.defaultScriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
        this.messageSchedulerListener = new MessageSchedulerListener();
        this.redisScript = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.PUSH_MESSAGE);
        this.queueRunningState = new ConcurrentHashMap<String, Boolean>(queueNames.size());
        this.queueNameToScheduledTask = new ConcurrentHashMap<String, ScheduledTaskDetail>(queueNames.size());
        this.channelNameToQueueName = new ConcurrentHashMap<String, String>(queueNames.size());
        this.queueNameToZsetName = new ConcurrentHashMap<String, String>(queueNames.size());
        this.queueNameToLastMessageSeenTime = new ConcurrentHashMap<String, Long>(queueNames.size());
        this.createScheduler(queueNames.size());
        for (String queueName : queueNames) {
            this.queueRunningState.put(queueName, false);
        }
    }

    public void onApplicationEvent(QueueInitializationEvent event) {
        this.doStop();
        if (event.isStart()) {
            if (CollectionUtils.isEmpty(event.getQueueDetailMap())) {
                return;
            }
            this.initialize(event.getQueueDetailMap());
            this.doStart();
        }
    }

    private class MessageSchedulerListener
    implements MessageListener {
        private MessageSchedulerListener() {
        }

        public void onMessage(Message message, byte[] pattern) {
            if (message.getBody().length == 0 || message.getChannel().length == 0) {
                return;
            }
            String body = new String(message.getBody());
            String channel = new String(message.getChannel());
            MessageScheduler.this.getLogger().debug("Body: {}  Channel: {}", (Object)body, (Object)channel);
            try {
                Long startTime = Long.parseLong(body);
                String queueName = (String)MessageScheduler.this.channelNameToQueueName.get(channel);
                if (queueName == null) {
                    MessageScheduler.this.getLogger().warn("Unknown channel name {}", (Object)channel);
                    return;
                }
                String zsetName = (String)MessageScheduler.this.queueNameToZsetName.get(queueName);
                if (zsetName == null) {
                    MessageScheduler.this.getLogger().warn("Unknown zset name {}", (Object)queueName);
                    return;
                }
                MessageScheduler.this.schedule(queueName, zsetName, startTime, false);
            }
            catch (NumberFormatException e) {
                MessageScheduler.this.getLogger().error("Invalid data {} on a channel {}", (Object)body, (Object)channel);
            }
        }
    }

    private class MessageMoverTask
    implements Runnable {
        private final String queueName;
        private final String zsetName;

        MessageMoverTask(String queueName, String zsetName) {
            this.queueName = queueName;
            this.zsetName = zsetName;
        }

        String getQueueName() {
            return this.queueName;
        }

        @Override
        public void run() {
            try {
                if (MessageScheduler.this.isQueueActive(this.queueName)) {
                    long currentTime = System.currentTimeMillis();
                    Long value = (Long)MessageScheduler.this.defaultScriptExecutor.execute(MessageScheduler.this.redisScript, Arrays.asList(this.queueName, this.zsetName), new Object[]{currentTime, 100});
                    MessageScheduler.this.schedule(this.queueName, this.zsetName, MessageScheduler.this.getNextScheduleTime(System.currentTimeMillis(), value), true);
                }
            }
            catch (RedisSystemException currentTime) {
            }
            catch (Exception e) {
                MessageScheduler.this.getLogger().warn("Task execution failed for queue: {}", (Object)this.queueName, (Object)e);
            }
        }
    }
}

