/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

class RedisScriptFactory {
    RedisScriptFactory() {
    }

    static RedisScript getScript(ScriptType type) {
        ClassPathResource resource = new ClassPathResource(type.getPath());
        DefaultRedisScript script = new DefaultRedisScript();
        script.setLocation((Resource)resource);
        switch (type) {
            case ADD_MESSAGE: 
            case MOVE_MESSAGE: 
            case REPLACE_MESSAGE: 
            case PUSH_MESSAGE: {
                script.setResultType(Long.class);
                return script;
            }
            case REMOVE_MESSAGE: {
                script.setResultType(RqueueMessage.class);
                return script;
            }
        }
        return null;
    }

    static enum ScriptType {
        ADD_MESSAGE("scripts/add-message.lua"),
        REMOVE_MESSAGE("scripts/remove-message.lua"),
        REPLACE_MESSAGE("scripts/replace-message.lua"),
        MOVE_MESSAGE("scripts/move-message.lua"),
        PUSH_MESSAGE("scripts/push-message.lua");

        private String path;

        private ScriptType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

