/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.listener.MappingInformation;
import com.github.sonus21.rqueue.utils.ValueResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.Assert;
import org.springframework.util.comparator.ComparableComparator;

public class RqueueMessageHandler
extends AbstractMethodMessageHandler<MappingInformation> {
    private List<MessageConverter> messageConverters;

    public RqueueMessageHandler() {
        this.messageConverters = new ArrayList<MessageConverter>();
        this.addDefaultMessageConverter();
    }

    public RqueueMessageHandler(List<MessageConverter> messageConverters) {
        this.setMessageConverters(messageConverters);
    }

    private void addDefaultMessageConverter() {
        this.messageConverters.add(new GenericMessageConverter());
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<PayloadArgumentResolver> resolvers = new ArrayList<PayloadArgumentResolver>(this.getCustomArgumentResolvers());
        CompositeMessageConverter compositeMessageConverter = new CompositeMessageConverter(this.getMessageConverters());
        resolvers.add(new PayloadArgumentResolver((MessageConverter)compositeMessageConverter));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return new ArrayList(this.getCustomReturnValueHandlers());
    }

    protected boolean isHandler(Class<?> beanType) {
        return true;
    }

    protected MappingInformation getMappingForMethod(Method method, Class<?> handlerType) {
        RqueueListener rqueueListener = (RqueueListener)AnnotationUtils.findAnnotation((Method)method, RqueueListener.class);
        if (rqueueListener != null) {
            MappingInformation mappingInformation = new MappingInformation(this.resolveQueueNames(rqueueListener.value()), ValueResolver.resolveToBoolean(this.getApplicationContext(), rqueueListener.delayedQueue()), ValueResolver.resolveValueToInteger(this.getApplicationContext(), rqueueListener.numRetries()), this.resolveDelayedQueue(rqueueListener.deadLetterQueue()));
            if (mappingInformation.isValid()) {
                return mappingInformation;
            }
            this.logger.warn((Object)("Queue '" + mappingInformation + "' not configured properly"));
        }
        return null;
    }

    private String resolveDelayedQueue(String dlqName) {
        String[] resolvedValues = ValueResolver.resolveValueToArrayOfStrings(this.getApplicationContext(), dlqName);
        if (resolvedValues.length == 1) {
            return resolvedValues[0];
        }
        throw new IllegalStateException("more than one dead letter queue can not be configure '" + dlqName + "'");
    }

    private Set<String> resolveQueueNames(String[] queueNames) {
        HashSet<String> result = new HashSet<String>(queueNames.length);
        for (String queueName : queueNames) {
            result.addAll(Arrays.asList(ValueResolver.resolveValueToArrayOfStrings(this.getApplicationContext(), queueName)));
        }
        return result;
    }

    protected Set<String> getDirectLookupDestinations(MappingInformation mapping) {
        return mapping.getQueueNames();
    }

    protected String getDestination(Message<?> message) {
        return (String)message.getHeaders().get((Object)"QUEUE_NAME");
    }

    protected MappingInformation getMatchingMapping(MappingInformation mapping, Message<?> message) {
        if (mapping.getQueueNames().contains(this.getDestination(message))) {
            return mapping;
        }
        return null;
    }

    protected Comparator<MappingInformation> getMappingComparator(Message<?> message) {
        return new ComparableComparator();
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        super.processHandlerMethodException(handlerMethod, ex, message);
        throw new MessagingException("An exception occurred while invoking the handler method", (Throwable)ex);
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"messageConverters list can not be empty or null");
        this.messageConverters = messageConverters;
        this.addDefaultMessageConverter();
    }
}

