/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.metrics.QueueCounter;
import com.github.sonus21.rqueue.metrics.RqueueMetricsProperties;
import com.github.sonus21.rqueue.utils.QueueInfo;
import com.github.sonus21.rqueue.utils.QueueInitializationEvent;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.springframework.context.ApplicationListener;

public class RqueueMetrics
implements ApplicationListener<QueueInitializationEvent> {
    private static final String QUEUE_SIZE = "queue.size";
    private static final String DELAYED_QUEUE_SIZE = "delayed.queue.size";
    private static final String PROCESSING_QUEUE_SIZE = "processing.queue.size";
    private static final String DEAD_LETTER_QUEUE_SIZE = "dead.letter.queue.size";
    private RqueueMessageTemplate rqueueMessageTemplate;
    private RqueueMetricsProperties metricsProperties;
    private MeterRegistry meterRegistry;
    private QueueCounter queueCounter;

    public RqueueMetrics(RqueueMessageTemplate rqueueMessageTemplate, RqueueMetricsProperties metricsProperties, MeterRegistry meterRegistry, QueueCounter queueCounter) {
        this.metricsProperties = metricsProperties;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.meterRegistry = meterRegistry;
        this.queueCounter = queueCounter;
    }

    private long size(String name, boolean isZset) {
        Long val = !isZset ? this.rqueueMessageTemplate.getListLength(name) : this.rqueueMessageTemplate.getZsetSize(name);
        if (val == null || val < 0L) {
            return 0L;
        }
        return val;
    }

    private void monitor(Map<String, ConsumerQueueDetail> queueDetailMap) {
        for (ConsumerQueueDetail queueDetail : queueDetailMap.values()) {
            Tags queueTags = Tags.concat((Iterable)this.metricsProperties.getMetricTags(), (String[])new String[]{"queue", queueDetail.getQueueName()});
            Gauge.builder((String)QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getQueueName(), false)).tags((Iterable)queueTags).description("The number of entries in this queue").register(this.meterRegistry);
            Gauge.builder((String)PROCESSING_QUEUE_SIZE, (Object)queueDetail, c -> this.size(QueueInfo.getProcessingQueueName(queueDetail.getQueueName()), true)).tags((Iterable)queueTags).description("The number of entries in the processing queue").register(this.meterRegistry);
            if (queueDetail.isDelayedQueue()) {
                Gauge.builder((String)DELAYED_QUEUE_SIZE, (Object)queueDetail, c -> this.size(QueueInfo.getTimeQueueName(queueDetail.getQueueName()), true)).tags((Iterable)queueTags).description("The number of entries waiting in the delayed queue").register(this.meterRegistry);
            }
            if (queueDetail.isDlqSet()) {
                Gauge.Builder builder = Gauge.builder((String)DEAD_LETTER_QUEUE_SIZE, (Object)queueDetail, c -> this.size(queueDetail.getDlqName(), false));
                builder.tags((Iterable)queueTags);
                builder.description("The number of entries in the dead letter queue");
                builder.register(this.meterRegistry);
            }
            this.queueCounter.registerQueue(this.metricsProperties, queueTags, this.meterRegistry, queueDetail.getQueueName());
        }
    }

    public void onApplicationEvent(QueueInitializationEvent event) {
        this.monitor(event.getQueueDetailMap());
    }

    public QueueCounter getQueueCounter() {
        return this.queueCounter;
    }
}

