/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.producer;

import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.producer.MessageWriter;
import com.github.sonus21.rqueue.utils.QueueInfo;
import com.github.sonus21.rqueue.utils.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;

public class RqueueMessageSender {
    private static final int DEFAULT_MAX_MESSAGE = 1000;
    private MessageWriter messageWriter;
    private RqueueMessageTemplate messageTemplate;

    private RqueueMessageSender(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters, boolean addDefault) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate can not be null");
        Assert.notEmpty(messageConverters, (String)"messageConverters can  not be empty");
        this.messageTemplate = messageTemplate;
        this.messageWriter = new MessageWriter(messageTemplate, this.getMessageConverters(addDefault, messageConverters));
    }

    public RqueueMessageSender(RqueueMessageTemplate messageTemplate) {
        this(messageTemplate, Collections.singletonList(new GenericMessageConverter()), false);
    }

    public RqueueMessageSender(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters) {
        this(messageTemplate, messageConverters, true);
    }

    private List<MessageConverter> getMessageConverters(boolean addDefault, List<MessageConverter> messageConverters) {
        ArrayList<MessageConverter> messageConverterList = new ArrayList<MessageConverter>();
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        messageConverterList.add((MessageConverter)stringMessageConverter);
        if (addDefault) {
            messageConverterList.add(new GenericMessageConverter());
        }
        messageConverterList.addAll(messageConverters);
        return messageConverterList;
    }

    public boolean put(String queueName, Object message) {
        Validator.validateQueueNameAndMessage(queueName, message);
        return this.messageWriter.pushMessage(queueName, message, null, null);
    }

    public boolean put(String queueName, Object message, int retryCount) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateRetryCount(retryCount);
        return this.messageWriter.pushMessage(queueName, message, retryCount, null);
    }

    public boolean put(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateDelay(delayInMilliSecs);
        return this.messageWriter.pushMessage(queueName, message, null, delayInMilliSecs);
    }

    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        for (RqueueMessage message : this.messageTemplate.getAllMessages(queueName)) {
            messages.add(this.messageWriter.convertMessageToObject(message));
        }
        return messages;
    }

    public boolean put(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueueNameAndMessage(queueName, message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.messageWriter.pushMessage(queueName, message, retryCount, delayInMilliSecs);
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageWriter.getMessageConverters();
    }

    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName, Integer maxMessages) {
        Assert.notNull((Object)deadLetterQueueName, (String)"deadLetterQueueName must not be null");
        Assert.notNull((Object)queueName, (String)"queueName must not be null");
        Assert.isTrue((!deadLetterQueueName.equals(queueName) ? 1 : 0) != 0, (String)"deadLetterQueueName and queueName must be different");
        if (maxMessages == null) {
            maxMessages = 1000;
        }
        Assert.isTrue((maxMessages > 0 ? 1 : 0) != 0, (String)"maxMessage must be greater than zero");
        return this.messageTemplate.moveMessage(deadLetterQueueName, queueName, maxMessages);
    }

    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName) {
        return this.moveMessageFromDeadLetterToQueue(deadLetterQueueName, queueName, null);
    }

    public void deleteAllMessages(String queueName) {
        this.messageTemplate.deleteKey(queueName);
        this.messageTemplate.deleteKey(QueueInfo.getProcessingQueueName(queueName));
        this.messageTemplate.deleteKey(QueueInfo.getTimeQueueName(queueName));
    }
}

