/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.exception.TimedOutException;
import java.util.function.BooleanSupplier;

public class WaitForUtil {
    private WaitForUtil() {
    }

    public static void waitFor(BooleanSupplier callback, long waitTimeInMilliSeconds, String description) throws TimedOutException {
        WaitForUtil.waitFor(callback, waitTimeInMilliSeconds, description, () -> {});
    }

    public static void waitFor(BooleanSupplier callback, String description) throws TimedOutException {
        WaitForUtil.waitFor(callback, 10000L, description);
    }

    public static void waitFor(BooleanSupplier callback, String description, Runnable postmortem) throws TimedOutException {
        WaitForUtil.waitFor(callback, 10000L, description, postmortem);
    }

    public static void waitFor(BooleanSupplier callback, long waitTimeInMilliSeconds, String description, Runnable postmortem) throws TimedOutException {
        long endTime = System.currentTimeMillis() + waitTimeInMilliSeconds;
        do {
            if (Boolean.TRUE.equals(callback.getAsBoolean())) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (System.currentTimeMillis() < endTime);
        try {
            postmortem.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new TimedOutException("Timed out waiting for " + description);
    }
}

