/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.QueueRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageSender;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.utils.MessageUtils;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;

public class RqueueMessageSenderImpl
implements RqueueMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageSenderImpl.class);
    private final CompositeMessageConverter messageConverter;
    private RqueueMessageTemplate messageTemplate;
    @Autowired
    private RqueueRedisTemplate<String> stringRqueueRedisTemplate;
    @Autowired
    private RqueueConfig rqueueConfig;

    private RqueueMessageSenderImpl(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters, boolean addDefault) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate cannot be null");
        Assert.notEmpty(messageConverters, (String)"messageConverters cannot be empty");
        this.messageTemplate = messageTemplate;
        this.messageConverter = new CompositeMessageConverter(this.getMessageConverters(addDefault, messageConverters));
    }

    public RqueueMessageSenderImpl(RqueueMessageTemplate messageTemplate) {
        this(messageTemplate, Collections.singletonList(new GenericMessageConverter()), false);
    }

    public RqueueMessageSenderImpl(RqueueMessageTemplate messageTemplate, List<MessageConverter> messageConverters) {
        this(messageTemplate, messageConverters, false);
    }

    @Override
    public boolean enqueue(String queueName, Object message) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        return this.pushMessage(queueName, message, null, null);
    }

    @Override
    public boolean enqueueWithRetry(String queueName, Object message, int retryCount) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        return this.pushMessage(queueName, message, retryCount, null);
    }

    @Override
    public boolean enqueueWithPriority(String queueName, String priority, Object message) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), message, null, null);
    }

    @Override
    public boolean enqueueIn(String queueName, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, message, null, delayInMilliSecs);
    }

    @Override
    public boolean enqueueInWithRetry(String queueName, Object message, int retryCount, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validateMessage(message);
        Validator.validateRetryCount(retryCount);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(queueName, message, retryCount, delayInMilliSecs);
    }

    @Override
    public boolean enqueueInWithPriority(String queueName, String priority, Object message, long delayInMilliSecs) {
        Validator.validateQueue(queueName);
        Validator.validatePriority(priority);
        Validator.validateMessage(message);
        Validator.validateDelay(delayInMilliSecs);
        return this.pushMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), message, null, delayInMilliSecs);
    }

    @Override
    public List<Object> getAllMessages(String queueName) {
        ArrayList<Object> messages = new ArrayList<Object>();
        QueueDetail queueDetail = QueueRegistry.get(queueName);
        for (RqueueMessage message : this.messageTemplate.getAllMessages(queueDetail.getQueueName(), queueDetail.getProcessingQueueName(), queueDetail.getDelayedQueueName())) {
            messages.add(MessageUtils.convertMessageToObject(message, (MessageConverter)this.messageConverter));
        }
        return messages;
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public List<MessageConverter> getMessageConverters() {
        return this.messageConverter.getConverters();
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName, Integer maxMessages) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, maxMessages).isSuccess();
    }

    @Override
    public boolean moveMessageFromDeadLetterToQueue(String deadLetterQueueName, String queueName) {
        return this.moveMessageListToList(deadLetterQueueName, queueName, null).isSuccess();
    }

    private MessageMoveResult moveMessageListToList(String sourceQueue, String destinationQueue, Integer maxMessage) {
        Assert.notNull((Object)sourceQueue, (String)"sourceQueue must not be null");
        Assert.notNull((Object)destinationQueue, (String)"destinationQueue must not be null");
        Assert.isTrue((!sourceQueue.equals(destinationQueue) ? 1 : 0) != 0, (String)"sourceQueue and destinationQueue must be different");
        Integer messageCount = maxMessage;
        if (messageCount == null) {
            messageCount = 100;
        }
        Assert.isTrue((messageCount > 0 ? 1 : 0) != 0, (String)"maxMessage must be greater than zero");
        return this.messageTemplate.moveMessageListToList(sourceQueue, destinationQueue, messageCount);
    }

    @Override
    public boolean deleteAllMessages(String queueName) {
        QueueDetail queueDetail = QueueRegistry.get(queueName);
        this.stringRqueueRedisTemplate.delete(queueDetail.getQueueName());
        this.stringRqueueRedisTemplate.delete(queueDetail.getProcessingQueueName());
        this.stringRqueueRedisTemplate.delete(queueDetail.getDelayedQueueName());
        return true;
    }

    private boolean pushMessage(String queueName, Object message, Integer retryCount, Long delayInMilliSecs) {
        QueueDetail queueDetail = QueueRegistry.get(queueName);
        RqueueMessage rqueueMessage = MessageUtils.buildMessage((MessageConverter)this.messageConverter, queueDetail.getQueueName(), message, retryCount, delayInMilliSecs);
        try {
            if (delayInMilliSecs == null || delayInMilliSecs <= 100L) {
                this.messageTemplate.addMessage(queueDetail.getQueueName(), rqueueMessage);
            } else {
                this.messageTemplate.addMessageWithDelay(queueDetail.getDelayedQueueName(), queueDetail.getDelayedQueueChannelName(), rqueueMessage);
            }
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return false;
        }
        return true;
    }

    private List<MessageConverter> getMessageConverters(boolean addDefault, List<MessageConverter> messageConverters) {
        ArrayList<MessageConverter> messageConverterList = new ArrayList<MessageConverter>();
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        messageConverterList.add((MessageConverter)stringMessageConverter);
        if (addDefault) {
            messageConverterList.add(new GenericMessageConverter());
        }
        messageConverterList.addAll(messageConverters);
        return messageConverterList;
    }

    @Override
    public void registerQueue(String queueName, String ... priorities) {
        Validator.validateQueue(queueName);
        Assert.notNull((Object)priorities, (String)"priorities cannot be null");
        QueueDetail queueDetail = QueueDetail.builder().name(queueName).active(false).queueName(this.rqueueConfig.getQueueName(queueName)).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName)).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName)).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName)).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName)).build();
        QueueRegistry.register(queueDetail);
        for (String priority : priorities) {
            String suffix = PriorityUtils.getSuffix(priority);
            queueDetail = QueueDetail.builder().name(queueName + suffix).active(false).queueName(this.rqueueConfig.getQueueName(queueName) + suffix).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName) + suffix).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName) + suffix).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName) + suffix).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName) + suffix).build();
            QueueRegistry.register(queueDetail);
        }
    }
}

