/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.event.Level;

abstract class MessageContainerBase
implements Runnable {
    protected final WeakReference<RqueueMessageListenerContainer> container;
    private final Logger log;
    private final String groupName;

    MessageContainerBase(Logger log, String groupName, RqueueMessageListenerContainer container) {
        this(log, groupName, new WeakReference<RqueueMessageListenerContainer>(container));
    }

    MessageContainerBase(Logger log, String groupName, WeakReference<RqueueMessageListenerContainer> container) {
        this.log = log;
        this.groupName = groupName;
        this.container = container;
    }

    protected RqueueMessageTemplate getRqueueMessageTemplate() {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).getRqueueMessageTemplate();
    }

    boolean isQueueActive(String queueName) {
        return ((RqueueMessageListenerContainer)Objects.requireNonNull(this.container.get())).isQueueActive(queueName);
    }

    void log(Level level, String msg, Throwable t, Object ... objects) {
        if (level == Level.DEBUG && !this.log.isDebugEnabled()) {
            return;
        }
        if (level == Level.ERROR && !this.log.isErrorEnabled()) {
            return;
        }
        if (level == Level.INFO && !this.log.isInfoEnabled()) {
            return;
        }
        if (level == Level.WARN && !this.log.isWarnEnabled()) {
            return;
        }
        Object[] objects1 = new Object[objects.length + 1 + (t == null ? 0 : 1)];
        System.arraycopy(objects, 0, objects1, 1, objects.length);
        objects1[0] = this.groupName;
        if (t != null) {
            objects1[objects1.length - 1] = t;
        }
        String txt = "[{}] " + msg;
        switch (level) {
            case INFO: {
                this.log.info(txt, objects1);
                break;
            }
            case WARN: {
                this.log.warn(txt, objects1);
                break;
            }
            case DEBUG: {
                this.log.debug(txt, objects1);
                break;
            }
            case ERROR: {
                this.log.error(txt, objects1);
                break;
            }
            default: {
                this.log.trace(txt, objects1);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (Exception e) {
            this.log(Level.ERROR, "Failed {}", e, e.getMessage());
        }
    }

    abstract void start();

    boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    boolean isWarningEnabled() {
        return this.log.isWarnEnabled();
    }
}

