/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.models.Concurrency;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class QueueDetail {
    private String name;
    private int numRetry;
    private long visibilityTimeout;
    private String queueName;
    private String deadLetterQueueName;
    private String processingQueueName;
    private String processingQueueChannelName;
    private String delayedQueueName;
    private String delayedQueueChannelName;
    private boolean active;
    private Concurrency concurrency;
    private Map<String, Integer> priority;
    private String priorityGroup;
    private boolean systemGenerated;

    public boolean isDlqSet() {
        return !StringUtils.isEmpty(this.deadLetterQueueName);
    }

    public QueueConfig toConfig() {
        QueueConfig queueConfig = QueueConfig.builder().name(this.name).numRetry(this.numRetry).queueName(this.queueName).delayedQueueName(this.delayedQueueName).processingQueueName(this.processingQueueName).visibilityTimeout(this.visibilityTimeout).createdOn(System.currentTimeMillis()).updatedOn(System.currentTimeMillis()).deadLetterQueues(new LinkedHashSet<String>()).concurrency(this.concurrency.toMinMax()).priority(this.priority).priorityGroup(this.priorityGroup).systemGenerated(this.systemGenerated).build();
        if (this.isDlqSet()) {
            queueConfig.addDeadLetterQueue(this.deadLetterQueueName);
        }
        return queueConfig;
    }

    List<QueueDetail> expandQueueDetail(boolean addDefault, int priority) {
        ArrayList<QueueDetail> queueDetails = new ArrayList<QueueDetail>();
        for (Map.Entry<String, Integer> entry : this.getPriority().entrySet()) {
            QueueDetail cloneQueueDetail = this.cloneQueueDetail(entry.getKey(), entry.getValue(), true, this.name);
            queueDetails.add(cloneQueueDetail);
        }
        if (addDefault) {
            int defaultPriority = priority;
            if (defaultPriority == -1) {
                ArrayList<Integer> priorities = new ArrayList<Integer>(this.getPriority().values());
                priorities.sort(Comparator.comparingInt(o -> o));
                defaultPriority = (Integer)priorities.get(priorities.size() / 2);
            }
            HashMap<String, Integer> priorityMap = new HashMap<String, Integer>(this.priority);
            priorityMap.put("DEFAULT_PRIORITY", defaultPriority);
            this.priority = Collections.unmodifiableMap(priorityMap);
            this.priorityGroup = this.name;
            queueDetails.add(this);
        }
        return queueDetails;
    }

    private QueueDetail cloneQueueDetail(String priorityName, Integer priority, boolean systemGenerated, String priorityGroup) {
        if (priority == null || priorityName == null) {
            throw new IllegalStateException("priority name is null");
        }
        String suffix = PriorityUtils.getSuffix(priorityName);
        return QueueDetail.builder().numRetry(this.numRetry).visibilityTimeout(this.visibilityTimeout).deadLetterQueueName(this.deadLetterQueueName).name(this.name + suffix).queueName(this.queueName + suffix).processingQueueName(this.processingQueueName + suffix).processingQueueChannelName(this.processingQueueChannelName + suffix).delayedQueueName(this.delayedQueueName + suffix).delayedQueueChannelName(this.delayedQueueChannelName + suffix).active(this.active).systemGenerated(systemGenerated).priorityGroup(priorityGroup).concurrency(this.concurrency).priority(Collections.singletonMap("DEFAULT_PRIORITY", priority)).build();
    }

    @Generated
    QueueDetail(String name, int numRetry, long visibilityTimeout, String queueName, String deadLetterQueueName, String processingQueueName, String processingQueueChannelName, String delayedQueueName, String delayedQueueChannelName, boolean active, Concurrency concurrency, Map<String, Integer> priority, String priorityGroup, boolean systemGenerated) {
        this.name = name;
        this.numRetry = numRetry;
        this.visibilityTimeout = visibilityTimeout;
        this.queueName = queueName;
        this.deadLetterQueueName = deadLetterQueueName;
        this.processingQueueName = processingQueueName;
        this.processingQueueChannelName = processingQueueChannelName;
        this.delayedQueueName = delayedQueueName;
        this.delayedQueueChannelName = delayedQueueChannelName;
        this.active = active;
        this.concurrency = concurrency;
        this.priority = priority;
        this.priorityGroup = priorityGroup;
        this.systemGenerated = systemGenerated;
    }

    @Generated
    public static QueueDetailBuilder builder() {
        return new QueueDetailBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getNumRetry() {
        return this.numRetry;
    }

    @Generated
    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getDeadLetterQueueName() {
        return this.deadLetterQueueName;
    }

    @Generated
    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    @Generated
    public String getProcessingQueueChannelName() {
        return this.processingQueueChannelName;
    }

    @Generated
    public String getDelayedQueueName() {
        return this.delayedQueueName;
    }

    @Generated
    public String getDelayedQueueChannelName() {
        return this.delayedQueueChannelName;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public Map<String, Integer> getPriority() {
        return this.priority;
    }

    @Generated
    public String getPriorityGroup() {
        return this.priorityGroup;
    }

    @Generated
    public boolean isSystemGenerated() {
        return this.systemGenerated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueDetail)) {
            return false;
        }
        QueueDetail other = (QueueDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getNumRetry() != other.getNumRetry()) {
            return false;
        }
        if (this.getVisibilityTimeout() != other.getVisibilityTimeout()) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$deadLetterQueueName = this.getDeadLetterQueueName();
        String other$deadLetterQueueName = other.getDeadLetterQueueName();
        if (this$deadLetterQueueName == null ? other$deadLetterQueueName != null : !this$deadLetterQueueName.equals(other$deadLetterQueueName)) {
            return false;
        }
        String this$processingQueueName = this.getProcessingQueueName();
        String other$processingQueueName = other.getProcessingQueueName();
        if (this$processingQueueName == null ? other$processingQueueName != null : !this$processingQueueName.equals(other$processingQueueName)) {
            return false;
        }
        String this$processingQueueChannelName = this.getProcessingQueueChannelName();
        String other$processingQueueChannelName = other.getProcessingQueueChannelName();
        if (this$processingQueueChannelName == null ? other$processingQueueChannelName != null : !this$processingQueueChannelName.equals(other$processingQueueChannelName)) {
            return false;
        }
        String this$delayedQueueName = this.getDelayedQueueName();
        String other$delayedQueueName = other.getDelayedQueueName();
        if (this$delayedQueueName == null ? other$delayedQueueName != null : !this$delayedQueueName.equals(other$delayedQueueName)) {
            return false;
        }
        String this$delayedQueueChannelName = this.getDelayedQueueChannelName();
        String other$delayedQueueChannelName = other.getDelayedQueueChannelName();
        if (this$delayedQueueChannelName == null ? other$delayedQueueChannelName != null : !this$delayedQueueChannelName.equals(other$delayedQueueChannelName)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        Concurrency this$concurrency = this.getConcurrency();
        Concurrency other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        Map<String, Integer> this$priority = this.getPriority();
        Map<String, Integer> other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$priorityGroup = this.getPriorityGroup();
        String other$priorityGroup = other.getPriorityGroup();
        if (this$priorityGroup == null ? other$priorityGroup != null : !this$priorityGroup.equals(other$priorityGroup)) {
            return false;
        }
        return this.isSystemGenerated() == other.isSystemGenerated();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueDetail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getNumRetry();
        long $visibilityTimeout = this.getVisibilityTimeout();
        result = result * 59 + (int)($visibilityTimeout >>> 32 ^ $visibilityTimeout);
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $deadLetterQueueName = this.getDeadLetterQueueName();
        result = result * 59 + ($deadLetterQueueName == null ? 43 : $deadLetterQueueName.hashCode());
        String $processingQueueName = this.getProcessingQueueName();
        result = result * 59 + ($processingQueueName == null ? 43 : $processingQueueName.hashCode());
        String $processingQueueChannelName = this.getProcessingQueueChannelName();
        result = result * 59 + ($processingQueueChannelName == null ? 43 : $processingQueueChannelName.hashCode());
        String $delayedQueueName = this.getDelayedQueueName();
        result = result * 59 + ($delayedQueueName == null ? 43 : $delayedQueueName.hashCode());
        String $delayedQueueChannelName = this.getDelayedQueueChannelName();
        result = result * 59 + ($delayedQueueChannelName == null ? 43 : $delayedQueueChannelName.hashCode());
        result = result * 59 + (this.isActive() ? 79 : 97);
        Concurrency $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        Map<String, Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $priorityGroup = this.getPriorityGroup();
        result = result * 59 + ($priorityGroup == null ? 43 : $priorityGroup.hashCode());
        result = result * 59 + (this.isSystemGenerated() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "QueueDetail(name=" + this.getName() + ", numRetry=" + this.getNumRetry() + ", visibilityTimeout=" + this.getVisibilityTimeout() + ", queueName=" + this.getQueueName() + ", deadLetterQueueName=" + this.getDeadLetterQueueName() + ", processingQueueName=" + this.getProcessingQueueName() + ", processingQueueChannelName=" + this.getProcessingQueueChannelName() + ", delayedQueueName=" + this.getDelayedQueueName() + ", delayedQueueChannelName=" + this.getDelayedQueueChannelName() + ", active=" + this.isActive() + ", concurrency=" + this.getConcurrency() + ", priority=" + this.getPriority() + ", priorityGroup=" + this.getPriorityGroup() + ", systemGenerated=" + this.isSystemGenerated() + ")";
    }

    @Generated
    public static class QueueDetailBuilder {
        @Generated
        private String name;
        @Generated
        private int numRetry;
        @Generated
        private long visibilityTimeout;
        @Generated
        private String queueName;
        @Generated
        private String deadLetterQueueName;
        @Generated
        private String processingQueueName;
        @Generated
        private String processingQueueChannelName;
        @Generated
        private String delayedQueueName;
        @Generated
        private String delayedQueueChannelName;
        @Generated
        private boolean active;
        @Generated
        private Concurrency concurrency;
        @Generated
        private Map<String, Integer> priority;
        @Generated
        private String priorityGroup;
        @Generated
        private boolean systemGenerated;

        @Generated
        QueueDetailBuilder() {
        }

        @Generated
        public QueueDetailBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public QueueDetailBuilder numRetry(int numRetry) {
            this.numRetry = numRetry;
            return this;
        }

        @Generated
        public QueueDetailBuilder visibilityTimeout(long visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        @Generated
        public QueueDetailBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder deadLetterQueueName(String deadLetterQueueName) {
            this.deadLetterQueueName = deadLetterQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueName(String processingQueueName) {
            this.processingQueueName = processingQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder processingQueueChannelName(String processingQueueChannelName) {
            this.processingQueueChannelName = processingQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder delayedQueueName(String delayedQueueName) {
            this.delayedQueueName = delayedQueueName;
            return this;
        }

        @Generated
        public QueueDetailBuilder delayedQueueChannelName(String delayedQueueChannelName) {
            this.delayedQueueChannelName = delayedQueueChannelName;
            return this;
        }

        @Generated
        public QueueDetailBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public QueueDetailBuilder concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Generated
        public QueueDetailBuilder priority(Map<String, Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public QueueDetailBuilder priorityGroup(String priorityGroup) {
            this.priorityGroup = priorityGroup;
            return this;
        }

        @Generated
        public QueueDetailBuilder systemGenerated(boolean systemGenerated) {
            this.systemGenerated = systemGenerated;
            return this;
        }

        @Generated
        public QueueDetail build() {
            return new QueueDetail(this.name, this.numRetry, this.visibilityTimeout, this.queueName, this.deadLetterQueueName, this.processingQueueName, this.processingQueueChannelName, this.delayedQueueName, this.delayedQueueChannelName, this.active, this.concurrency, this.priority, this.priorityGroup, this.systemGenerated);
        }

        @Generated
        public String toString() {
            return "QueueDetail.QueueDetailBuilder(name=" + this.name + ", numRetry=" + this.numRetry + ", visibilityTimeout=" + this.visibilityTimeout + ", queueName=" + this.queueName + ", deadLetterQueueName=" + this.deadLetterQueueName + ", processingQueueName=" + this.processingQueueName + ", processingQueueChannelName=" + this.processingQueueChannelName + ", delayedQueueName=" + this.delayedQueueName + ", delayedQueueChannelName=" + this.delayedQueueChannelName + ", active=" + this.active + ", concurrency=" + this.concurrency + ", priority=" + this.priority + ", priorityGroup=" + this.priorityGroup + ", systemGenerated=" + this.systemGenerated + ")";
        }
    }
}

