/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.metrics;

import com.github.sonus21.rqueue.config.MetricsProperties;
import com.github.sonus21.rqueue.listener.QueueDetail;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;

public class QueueCounter {
    static final String FAILURE_COUNT = "failure.count";
    static final String EXECUTION_COUNT = "execution.count";
    private Map<String, Counter> queueNameToFailureCounter = new HashMap<String, Counter>();
    private Map<String, Counter> queueNameToExecutionCounter = new HashMap<String, Counter>();

    private void updateCounter(Map<String, Counter> map, String queueName) {
        Counter counter = map.get(queueName);
        if (counter == null) {
            return;
        }
        counter.increment();
    }

    void updateFailureCount(String queueName) {
        this.updateCounter(this.queueNameToFailureCounter, queueName);
    }

    void updateExecutionCount(String queueName) {
        this.updateCounter(this.queueNameToExecutionCounter, queueName);
    }

    void registerQueue(MetricsProperties metricsProperties, Tags queueTags, MeterRegistry registry, QueueDetail queueDetail) {
        Counter counter;
        Counter.Builder builder;
        if (metricsProperties.countFailure()) {
            builder = Counter.builder((String)FAILURE_COUNT).tags((Iterable)queueTags.and("key", queueDetail.getQueueName())).description("Failure count");
            counter = builder.register(registry);
            this.queueNameToFailureCounter.put(queueDetail.getName(), counter);
        }
        if (metricsProperties.countExecution()) {
            builder = Counter.builder((String)EXECUTION_COUNT).tags((Iterable)queueTags.and("key", queueDetail.getQueueName())).description("Task execution count");
            counter = builder.register(registry);
            this.queueNameToExecutionCounter.put(queueDetail.getName(), counter);
        }
    }
}

