/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.sonus21.rqueue.models.MinMax;
import com.github.sonus21.rqueue.models.SerializableBase;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class QueueConfig
extends SerializableBase {
    private static final long serialVersionUID = 2644813429709395582L;
    private String id;
    private String name;
    private String queueName;
    private String processingQueueName;
    private String delayedQueueName;
    private int numRetry;
    private long visibilityTimeout;
    private MinMax<Integer> concurrency;
    private Set<String> deadLetterQueues;
    private boolean systemGenerated;
    private String priorityGroup;
    private Map<String, Integer> priority;
    private boolean deleted;
    private Long createdOn;
    private Long updatedOn;
    private Long deletedOn;

    public void updateTime() {
        this.updatedOn = System.currentTimeMillis();
    }

    public boolean updateRetryCount(int newRetryCount) {
        if (this.numRetry != newRetryCount) {
            this.numRetry = newRetryCount;
            return true;
        }
        return false;
    }

    public boolean addDeadLetterQueue(String queueName) {
        if (this.deadLetterQueues == null) {
            this.deadLetterQueues = new LinkedHashSet<String>();
        }
        if (!this.deadLetterQueues.contains(queueName)) {
            this.deadLetterQueues.add(queueName);
            return true;
        }
        return false;
    }

    public boolean updateVisibilityTimeout(long newTimeOut) {
        if (this.visibilityTimeout != newTimeOut) {
            this.visibilityTimeout = newTimeOut;
            return true;
        }
        return false;
    }

    public boolean updateConcurrency(MinMax<Integer> concurrency) {
        if (this.concurrency == null || !this.concurrency.equals(concurrency)) {
            this.concurrency = concurrency;
            return true;
        }
        return false;
    }

    public boolean updatePriorityGroup(String priorityGroup) {
        if (this.priorityGroup == null || !this.priorityGroup.equals(priorityGroup)) {
            this.priorityGroup = priorityGroup;
            return true;
        }
        return false;
    }

    public boolean updatePriority(Map<String, Integer> newPriority) {
        Integer val;
        if (CollectionUtils.isEmpty(newPriority) && !CollectionUtils.isEmpty(this.priority)) {
            this.priority = new HashMap<String, Integer>();
            return true;
        }
        if (CollectionUtils.isEmpty(newPriority)) {
            return false;
        }
        boolean updated = false;
        for (Map.Entry<String, Integer> entry : newPriority.entrySet()) {
            val = this.priority.get(entry.getKey());
            if (val != null && val.equals(entry.getValue())) continue;
            updated = true;
            this.priority.put(entry.getKey(), entry.getValue());
        }
        for (String key : this.priority.keySet()) {
            val = newPriority.get(key);
            if (val != null) continue;
            updated = true;
            this.priority.remove(key);
        }
        return updated;
    }

    @JsonIgnore
    public boolean isDeadLetterQueue(String name) {
        return this.deadLetterQueues.contains(name);
    }

    @JsonIgnore
    public boolean hasDeadLetterQueue() {
        return !CollectionUtils.isEmpty(this.deadLetterQueues);
    }

    @Generated
    public static QueueConfigBuilder builder() {
        return new QueueConfigBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    @Generated
    public String getDelayedQueueName() {
        return this.delayedQueueName;
    }

    @Generated
    public int getNumRetry() {
        return this.numRetry;
    }

    @Generated
    public long getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Generated
    public MinMax<Integer> getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public Set<String> getDeadLetterQueues() {
        return this.deadLetterQueues;
    }

    @Generated
    public boolean isSystemGenerated() {
        return this.systemGenerated;
    }

    @Generated
    public String getPriorityGroup() {
        return this.priorityGroup;
    }

    @Generated
    public Map<String, Integer> getPriority() {
        return this.priority;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Long getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public Long getDeletedOn() {
        return this.deletedOn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setProcessingQueueName(String processingQueueName) {
        this.processingQueueName = processingQueueName;
    }

    @Generated
    public void setDelayedQueueName(String delayedQueueName) {
        this.delayedQueueName = delayedQueueName;
    }

    @Generated
    public void setNumRetry(int numRetry) {
        this.numRetry = numRetry;
    }

    @Generated
    public void setVisibilityTimeout(long visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    @Generated
    public void setConcurrency(MinMax<Integer> concurrency) {
        this.concurrency = concurrency;
    }

    @Generated
    public void setDeadLetterQueues(Set<String> deadLetterQueues) {
        this.deadLetterQueues = deadLetterQueues;
    }

    @Generated
    public void setSystemGenerated(boolean systemGenerated) {
        this.systemGenerated = systemGenerated;
    }

    @Generated
    public void setPriorityGroup(String priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    @Generated
    public void setPriority(Map<String, Integer> priority) {
        this.priority = priority;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setDeletedOn(Long deletedOn) {
        this.deletedOn = deletedOn;
    }

    @Generated
    public String toString() {
        return "QueueConfig(id=" + this.getId() + ", name=" + this.getName() + ", queueName=" + this.getQueueName() + ", processingQueueName=" + this.getProcessingQueueName() + ", delayedQueueName=" + this.getDelayedQueueName() + ", numRetry=" + this.getNumRetry() + ", visibilityTimeout=" + this.getVisibilityTimeout() + ", concurrency=" + this.getConcurrency() + ", deadLetterQueues=" + this.getDeadLetterQueues() + ", systemGenerated=" + this.isSystemGenerated() + ", priorityGroup=" + this.getPriorityGroup() + ", priority=" + this.getPriority() + ", deleted=" + this.isDeleted() + ", createdOn=" + this.getCreatedOn() + ", updatedOn=" + this.getUpdatedOn() + ", deletedOn=" + this.getDeletedOn() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueConfig)) {
            return false;
        }
        QueueConfig other = (QueueConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        String this$processingQueueName = this.getProcessingQueueName();
        String other$processingQueueName = other.getProcessingQueueName();
        if (this$processingQueueName == null ? other$processingQueueName != null : !this$processingQueueName.equals(other$processingQueueName)) {
            return false;
        }
        String this$delayedQueueName = this.getDelayedQueueName();
        String other$delayedQueueName = other.getDelayedQueueName();
        if (this$delayedQueueName == null ? other$delayedQueueName != null : !this$delayedQueueName.equals(other$delayedQueueName)) {
            return false;
        }
        if (this.getNumRetry() != other.getNumRetry()) {
            return false;
        }
        if (this.getVisibilityTimeout() != other.getVisibilityTimeout()) {
            return false;
        }
        MinMax<Integer> this$concurrency = this.getConcurrency();
        MinMax<Integer> other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !((Object)this$concurrency).equals(other$concurrency)) {
            return false;
        }
        Set<String> this$deadLetterQueues = this.getDeadLetterQueues();
        Set<String> other$deadLetterQueues = other.getDeadLetterQueues();
        if (this$deadLetterQueues == null ? other$deadLetterQueues != null : !((Object)this$deadLetterQueues).equals(other$deadLetterQueues)) {
            return false;
        }
        if (this.isSystemGenerated() != other.isSystemGenerated()) {
            return false;
        }
        String this$priorityGroup = this.getPriorityGroup();
        String other$priorityGroup = other.getPriorityGroup();
        if (this$priorityGroup == null ? other$priorityGroup != null : !this$priorityGroup.equals(other$priorityGroup)) {
            return false;
        }
        Map<String, Integer> this$priority = this.getPriority();
        Map<String, Integer> other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$createdOn = this.getCreatedOn();
        Long other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Long this$updatedOn = this.getUpdatedOn();
        Long other$updatedOn = other.getUpdatedOn();
        if (this$updatedOn == null ? other$updatedOn != null : !((Object)this$updatedOn).equals(other$updatedOn)) {
            return false;
        }
        Long this$deletedOn = this.getDeletedOn();
        Long other$deletedOn = other.getDeletedOn();
        return !(this$deletedOn == null ? other$deletedOn != null : !((Object)this$deletedOn).equals(other$deletedOn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        String $processingQueueName = this.getProcessingQueueName();
        result = result * 59 + ($processingQueueName == null ? 43 : $processingQueueName.hashCode());
        String $delayedQueueName = this.getDelayedQueueName();
        result = result * 59 + ($delayedQueueName == null ? 43 : $delayedQueueName.hashCode());
        result = result * 59 + this.getNumRetry();
        long $visibilityTimeout = this.getVisibilityTimeout();
        result = result * 59 + (int)($visibilityTimeout >>> 32 ^ $visibilityTimeout);
        MinMax<Integer> $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : ((Object)$concurrency).hashCode());
        Set<String> $deadLetterQueues = this.getDeadLetterQueues();
        result = result * 59 + ($deadLetterQueues == null ? 43 : ((Object)$deadLetterQueues).hashCode());
        result = result * 59 + (this.isSystemGenerated() ? 79 : 97);
        String $priorityGroup = this.getPriorityGroup();
        result = result * 59 + ($priorityGroup == null ? 43 : $priorityGroup.hashCode());
        Map<String, Integer> $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Long $updatedOn = this.getUpdatedOn();
        result = result * 59 + ($updatedOn == null ? 43 : ((Object)$updatedOn).hashCode());
        Long $deletedOn = this.getDeletedOn();
        result = result * 59 + ($deletedOn == null ? 43 : ((Object)$deletedOn).hashCode());
        return result;
    }

    @Generated
    public QueueConfig(String id, String name, String queueName, String processingQueueName, String delayedQueueName, int numRetry, long visibilityTimeout, MinMax<Integer> concurrency, Set<String> deadLetterQueues, boolean systemGenerated, String priorityGroup, Map<String, Integer> priority, boolean deleted, Long createdOn, Long updatedOn, Long deletedOn) {
        this.id = id;
        this.name = name;
        this.queueName = queueName;
        this.processingQueueName = processingQueueName;
        this.delayedQueueName = delayedQueueName;
        this.numRetry = numRetry;
        this.visibilityTimeout = visibilityTimeout;
        this.concurrency = concurrency;
        this.deadLetterQueues = deadLetterQueues;
        this.systemGenerated = systemGenerated;
        this.priorityGroup = priorityGroup;
        this.priority = priority;
        this.deleted = deleted;
        this.createdOn = createdOn;
        this.updatedOn = updatedOn;
        this.deletedOn = deletedOn;
    }

    @Generated
    public QueueConfig() {
    }

    @Generated
    public static class QueueConfigBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String queueName;
        @Generated
        private String processingQueueName;
        @Generated
        private String delayedQueueName;
        @Generated
        private int numRetry;
        @Generated
        private long visibilityTimeout;
        @Generated
        private MinMax<Integer> concurrency;
        @Generated
        private Set<String> deadLetterQueues;
        @Generated
        private boolean systemGenerated;
        @Generated
        private String priorityGroup;
        @Generated
        private Map<String, Integer> priority;
        @Generated
        private boolean deleted;
        @Generated
        private Long createdOn;
        @Generated
        private Long updatedOn;
        @Generated
        private Long deletedOn;

        @Generated
        QueueConfigBuilder() {
        }

        @Generated
        public QueueConfigBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public QueueConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public QueueConfigBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder processingQueueName(String processingQueueName) {
            this.processingQueueName = processingQueueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder delayedQueueName(String delayedQueueName) {
            this.delayedQueueName = delayedQueueName;
            return this;
        }

        @Generated
        public QueueConfigBuilder numRetry(int numRetry) {
            this.numRetry = numRetry;
            return this;
        }

        @Generated
        public QueueConfigBuilder visibilityTimeout(long visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        @Generated
        public QueueConfigBuilder concurrency(MinMax<Integer> concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Generated
        public QueueConfigBuilder deadLetterQueues(Set<String> deadLetterQueues) {
            this.deadLetterQueues = deadLetterQueues;
            return this;
        }

        @Generated
        public QueueConfigBuilder systemGenerated(boolean systemGenerated) {
            this.systemGenerated = systemGenerated;
            return this;
        }

        @Generated
        public QueueConfigBuilder priorityGroup(String priorityGroup) {
            this.priorityGroup = priorityGroup;
            return this;
        }

        @Generated
        public QueueConfigBuilder priority(Map<String, Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public QueueConfigBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public QueueConfigBuilder createdOn(Long createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        @Generated
        public QueueConfigBuilder updatedOn(Long updatedOn) {
            this.updatedOn = updatedOn;
            return this;
        }

        @Generated
        public QueueConfigBuilder deletedOn(Long deletedOn) {
            this.deletedOn = deletedOn;
            return this;
        }

        @Generated
        public QueueConfig build() {
            return new QueueConfig(this.id, this.name, this.queueName, this.processingQueueName, this.delayedQueueName, this.numRetry, this.visibilityTimeout, this.concurrency, this.deadLetterQueues, this.systemGenerated, this.priorityGroup, this.priority, this.deleted, this.createdOn, this.updatedOn, this.deletedOn);
        }

        @Generated
        public String toString() {
            return "QueueConfig.QueueConfigBuilder(id=" + this.id + ", name=" + this.name + ", queueName=" + this.queueName + ", processingQueueName=" + this.processingQueueName + ", delayedQueueName=" + this.delayedQueueName + ", numRetry=" + this.numRetry + ", visibilityTimeout=" + this.visibilityTimeout + ", concurrency=" + this.concurrency + ", deadLetterQueues=" + this.deadLetterQueues + ", systemGenerated=" + this.systemGenerated + ", priorityGroup=" + this.priorityGroup + ", priority=" + this.priority + ", deleted=" + this.deleted + ", createdOn=" + this.createdOn + ", updatedOn=" + this.updatedOn + ", deletedOn=" + this.deletedOn + ")";
        }
    }
}

