/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum TaskStatus {
    MOVED_TO_DLQ("Moved to dead letter queue messages", true),
    SUCCESSFUL("Successful execution", true),
    DELETED("Message deleted", false),
    DISCARDED("Message discarded", true),
    RETRIED("Retired at least once", true),
    FAILED("failed", false),
    IGNORED("Ignored task", false),
    QUEUE_INACTIVE("Queue inactive", false);

    private String description;
    private boolean chartEnabled;

    public static List<TaskStatus> getActiveChartStatus() {
        return Arrays.stream(TaskStatus.values()).filter(TaskStatus::isChartEnabled).collect(Collectors.toList());
    }

    @Generated
    private TaskStatus(String description, boolean chartEnabled) {
        this.description = description;
        this.chartEnabled = chartEnabled;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isChartEnabled() {
        return this.chartEnabled;
    }
}

