/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.StringUtils;
import org.springframework.util.Assert;

public class Validator {
    private Validator() {
    }

    public static void validateMessage(Object message) {
        Assert.notNull((Object)message, (String)"message cannot be null");
    }

    public static void validateRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount must be positive");
        }
    }

    public static void validateDelay(long delayInMilliSecs) {
        if (delayInMilliSecs < 0L) {
            throw new IllegalArgumentException("delayInMilliSecs must be positive");
        }
    }

    public static void validateQueue(String queue) {
        if (StringUtils.isEmpty(queue)) {
            throw new IllegalArgumentException("queue cannot be empty");
        }
    }

    public static void validatePriority(String priority) {
        if (StringUtils.isEmpty(priority)) {
            throw new IllegalArgumentException("priority cannot be empty");
        }
    }
}

