/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.utils.MessageUtils;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RqueueMessageMetadataServiceImpl
implements RqueueMessageMetadataService {
    private final RqueueRedisTemplate<MessageMetadata> template;

    public RqueueMessageMetadataServiceImpl(RqueueRedisTemplate<MessageMetadata> template) {
        this.template = template;
    }

    @Autowired
    public RqueueMessageMetadataServiceImpl(RqueueConfig rqueueConfig) {
        this.template = new RqueueRedisTemplate(rqueueConfig.getConnectionFactory());
    }

    @Override
    public MessageMetadata get(String id) {
        return this.template.get(id);
    }

    @Override
    public List<MessageMetadata> findAll(Collection<String> ids) {
        return this.template.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void save(MessageMetadata messageMetadata, Duration duration) {
        Assert.notNull((Object)messageMetadata.getId(), (String)"messageMetadata id cannot be null");
        this.template.set(messageMetadata.getId(), messageMetadata, duration);
    }

    @Override
    public void deleteMessage(String messageId, Duration duration) {
        String id = MessageUtils.getMessageMetaId(messageId);
        MessageMetadata messageMetadata = this.get(id);
        if (messageMetadata == null) {
            messageMetadata = new MessageMetadata(id, messageId);
        }
        messageMetadata.setDeleted(true);
        messageMetadata.setDeletedOn(System.currentTimeMillis());
        this.template.set(messageMetadata.getId(), messageMetadata, duration);
    }

    @Override
    public void delete(String id) {
        this.template.delete(id);
    }
}

