/*
 * Decompiled with CFR 0.152.
 */
package dsplend.states;

import dsplend.crypto.Crypto;
import dsplend.crypto.Key;
import dsplend.utils.AJson;
import dsplend.utils.Utils;
import java.sql.Timestamp;

public class Account
extends AJson {
    private String privateKey;
    private String address;
    private String name;
    private long balance;
    private Timestamp updated;
    private Timestamp created;

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getBalance() {
        return this.balance;
    }

    public void setBalance(long balance) {
        this.balance = balance;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
    }

    public static Account create() throws Exception {
        Key key = new Key();
        byte[] publicKey = key.getPublicKeyBytes();
        System.out.println(Utils.toHexString(publicKey));
        byte[] hashablePublicKey = new byte[publicKey.length - 1];
        for (int i = 1; i < publicKey.length; ++i) {
            hashablePublicKey[i - 1] = publicKey[i];
        }
        byte[] hash = Crypto.hash(hashablePublicKey);
        byte[] address = new byte[20];
        for (int i = 0; i < address.length; ++i) {
            address[i] = hash[i + 12];
        }
        Account account = new Account();
        account.setAddress(Utils.toHexString(address));
        account.setPrivateKey(key.getPrivateKey());
        return account;
    }
}

