/*
 * Decompiled with CFR 0.152.
 */
package dsplend.states;

import dsplend.crypto.Crypto;
import dsplend.utils.AJson;
import dsplend.utils.Utils;
import java.io.ByteArrayOutputStream;
import javax.xml.bind.DatatypeConverter;

public class Transaction
extends AJson {
    private static final long serialVersionUID = -6784018212068358301L;
    private String hash;
    private byte type;
    private String from;
    private String to;
    private String value;
    private String code;
    private String method;
    private String params;
    private long time;
    private String signature;
    private String hertz;
    private String fromName;
    private String toName;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getHertz() {
        return this.hertz;
    }

    public void setHertz(String hertz) {
        this.hertz = hertz;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public static Transaction create(String privateKey, String from, String to, byte type, String value, String code, String method, String params, long time) throws Exception {
        byte[] privateKeyBytes = DatatypeConverter.parseHexBinary((String)privateKey);
        byte[] typeBytes = new byte[]{type};
        byte[] fromBytes = DatatypeConverter.parseHexBinary((String)from);
        byte[] toBytes = DatatypeConverter.parseHexBinary((String)to);
        byte[] valueBytes = value.getBytes();
        byte[] codeBytes = DatatypeConverter.parseHexBinary((String)code);
        byte[] methodBytes = method.getBytes();
        byte[] paramsBytes = params.getBytes();
        byte[] timeBytes = Utils.longToBytes(time);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(typeBytes);
        byteArrayOutputStream.write(fromBytes);
        byteArrayOutputStream.write(toBytes);
        byteArrayOutputStream.write(valueBytes);
        byteArrayOutputStream.write(codeBytes);
        byteArrayOutputStream.write(methodBytes);
        byteArrayOutputStream.write(paramsBytes);
        byteArrayOutputStream.write(timeBytes);
        byte[] hashBytes = Crypto.hash(byteArrayOutputStream.toByteArray());
        byte[] signatureBytes = Crypto.sign(privateKeyBytes, hashBytes);
        Transaction transaction = new Transaction();
        transaction.setHash(Utils.toHexString(hashBytes));
        transaction.setType(type);
        transaction.setFrom(from);
        transaction.setTo(to);
        transaction.setValue(value);
        transaction.setTime(time);
        transaction.setCode(code);
        transaction.setMethod(method);
        transaction.setParams(params);
        transaction.setHertz("0");
        transaction.setSignature(Utils.toHexString(signatureBytes));
        return transaction;
    }

    public static class Type {
        public static final byte TRANSFER_TOKENS = 0;
        public static final byte SET_NAME = 1;
        public static final byte SMART_CONTRACT = 2;
    }
}

