/*
 * Decompiled with CFR 0.152.
 */
package dsplend.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Http
implements AutoCloseable {
    private CloseableHttpClient closeableHttpClient;

    public Http() throws Exception {
        this.closeableHttpClient = HttpClients.createDefault();
    }

    public Http(boolean trustAll) throws Exception {
        this.closeableHttpClient = trustAll ? this.createTrustedCloseableHttpClient() : HttpClients.createDefault();
    }

    public String post(String url, Map<String, String> headers, String entity) throws Exception {
        String line;
        StringEntity stringEntity = new StringEntity(entity, "UTF-8");
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        stringEntity.setContentType("application/json; charset=UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpPost);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        StringBuilder responseStringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            responseStringBuilder.append(line);
        }
        return responseStringBuilder.toString();
    }

    public String post(String url, Map<String, String> headers, ArrayList<NameValuePair> nameValuePairs) throws Exception {
        String line;
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (nameValuePairs != null) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
        }
        CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpPost);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        StringBuilder responseStringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            responseStringBuilder.append(line);
        }
        return responseStringBuilder.toString();
    }

    public String get(String url, Map<String, String> headers) throws Exception {
        String line;
        HttpGet httpGet = new HttpGet(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httpGet);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        StringBuilder responseStringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            responseStringBuilder.append(line);
        }
        if (!responseStringBuilder.toString().startsWith("{")) {
            throw new Exception(responseStringBuilder.toString());
        }
        return responseStringBuilder.toString();
    }

    @Override
    public void close() throws Exception {
        this.closeableHttpClient.close();
    }

    private CloseableHttpClient createTrustedCloseableHttpClient() throws Exception {
        TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManager, new SecureRandom());
        return HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext)).build();
    }
}

