/*
 * Decompiled with CFR 0.152.
 */
package dsplend.utils;

import com.google.common.base.Preconditions;
import dsplend.crypto.Crypto;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.xml.bind.DatatypeConverter;

public class Utils {
    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        Preconditions.checkArgument((b.signum() >= 0 ? 1 : 0) != 0, (Object)"b must be positive or zero");
        Preconditions.checkArgument((numBytes > 0 ? 1 : 0) != 0, (Object)"numBytes must be positive");
        byte[] src = b.toByteArray();
        byte[] dest = new byte[numBytes];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        Preconditions.checkArgument((length <= numBytes ? 1 : 0) != 0, (Object)("The given number does not fit in " + numBytes));
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = numBytes - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseHexBinary((String)s);
    }

    public static byte[] longToBytes(long value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(0, value);
        return byteBuffer.array();
    }

    public static String toAddressFromPublicKey(String publicKey) throws Exception {
        byte[] publicKeyBytes = Utils.toByteArray(publicKey);
        byte[] hashablePublicKey = new byte[64];
        for (int i = 1; i < publicKeyBytes.length; ++i) {
            hashablePublicKey[i - 1] = publicKeyBytes[i];
        }
        byte[] hash = Crypto.hash(hashablePublicKey);
        byte[] address = new byte[20];
        for (int i = 0; i < address.length; ++i) {
            address[i] = hash[i + 12];
        }
        return Utils.toHexString(address);
    }
}

