/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoin;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bitcoin.Secp256k1Context;

public class NativeSecp256k1 {
    private static final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = reentrantReadWriteLock.readLock();
    private static final Lock writeLock = reentrantReadWriteLock.writeLock();
    private static ThreadLocal<ByteBuffer> nativeECDSABuffer = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sign(byte[] privateKey, byte[] hash) throws Exception {
        ByteBuffer byteBuff = nativeECDSABuffer.get();
        if (byteBuff == null || byteBuff.capacity() < 64) {
            byteBuff = ByteBuffer.allocateDirect(64);
            byteBuff.order(ByteOrder.nativeOrder());
            nativeECDSABuffer.set(byteBuff);
        }
        byteBuff.rewind();
        byteBuff.put(privateKey);
        byteBuff.put(hash);
        readLock.lock();
        try {
            byte[] byArray = NativeSecp256k1.secp256k1_sign_and_serialize_compact(byteBuff, Secp256k1Context.getContext());
            return byArray;
        }
        finally {
            readLock.unlock();
        }
    }

    private static native byte[] secp256k1_sign_and_serialize_compact(ByteBuffer var0, long var1);
}

