/*
 * Decompiled with CFR 0.152.
 */
package dsplend;

import dsplend.states.Account;
import dsplend.states.Node;
import dsplend.states.Receipt;
import dsplend.states.Transaction;
import dsplend.utils.AJson;
import dsplend.utils.Http;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Sdk {
    private String seedNodeIp;
    private Receipt receipt;

    public Sdk(String seedNodeIp) throws Exception {
        this.seedNodeIp = seedNodeIp;
    }

    public Receipt getReceipt() {
        return this.receipt;
    }

    public List<Node> getDelegates() throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + this.seedNodeIp + ":1975/v1/delegates", this.getHeaders()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            List list = AJson.deserializeList(Node.class, jsonObject.get("data").toString());
            return list;
        }
    }

    public Account createAccount() throws Exception {
        return Account.create();
    }

    public Receipt transferTokens(Node node, String privateKey, String from, String to, long tokens) throws Exception {
        try (Http http = new Http();){
            Transaction transaction = Transaction.create(privateKey, from, to, (byte)0, String.valueOf(tokens), "", "", "", System.currentTimeMillis());
            JSONObject jsonObject = new JSONObject(http.post("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions", this.getHeaders(), transaction.toString()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            this.receipt.setTransaction(transaction);
            Receipt receipt = this.receipt;
            return receipt;
        }
    }

    public Receipt transferTokens(Node node, Account fromAccount, Account toAccount, long tokens) throws Exception {
        try (Http http = new Http();){
            Transaction transaction = Transaction.create(fromAccount.getPrivateKey(), fromAccount.getAddress(), toAccount.getAddress(), (byte)0, String.valueOf(tokens), "", "", "", System.currentTimeMillis());
            JSONObject jsonObject = new JSONObject(http.post("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions", this.getHeaders(), transaction.toString()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            this.receipt.setTransaction(transaction);
            Receipt receipt = this.receipt;
            return receipt;
        }
    }

    public Receipt deployContract(Node node, Account fromAccount, String code) throws Exception {
        try (Http http = new Http();){
            Transaction transaction = Transaction.create(fromAccount.getPrivateKey(), fromAccount.getAddress(), "", (byte)2, "0", code, "", "", System.currentTimeMillis());
            JSONObject jsonObject = new JSONObject(http.post("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions", this.getHeaders(), transaction.toString()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            this.receipt.setTransaction(transaction);
            Receipt receipt = this.receipt;
            return receipt;
        }
    }

    public Receipt executeContract(Node node, Account fromAccount, String contractAddress, String method, String params, Boolean write) throws Exception {
        try (Http http = new Http();){
            Transaction transaction = Transaction.create(fromAccount.getPrivateKey(), fromAccount.getAddress(), contractAddress, write != false ? (byte)2 : 3, "0", "", method, params, System.currentTimeMillis());
            JSONObject jsonObject = new JSONObject(http.post("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions", this.getHeaders(), transaction.toString()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            this.receipt.setTransaction(transaction);
            Receipt receipt = this.receipt;
            return receipt;
        }
    }

    public Account getAccount(Node node, String address) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/accounts/" + address, this.getHeaders()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            if (this.receipt.isOk()) {
                Account account = (Account)AJson.deserialize(Account.class, jsonObject.get("data").toString());
                return account;
            }
            Account account = null;
            return account;
        }
    }

    public List<Transaction> getTransactions(Node node) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions", this.getHeaders()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            if (this.receipt.isOk()) {
                List list = AJson.deserializeList(Transaction.class, jsonObject.get("data").toString());
                return list;
            }
            List<Transaction> list = null;
            return list;
        }
    }

    public List<Transaction> getTransactionsByFromAddress(Node node, String address) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions/from/" + address, this.getHeaders()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            if (this.receipt.isOk()) {
                List list = AJson.deserializeList(Transaction.class, jsonObject.get("data").toString());
                return list;
            }
            List<Transaction> list = null;
            return list;
        }
    }

    public List<Transaction> getTransactionsByToAddress(Node node, String address) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions/to/" + address, this.getHeaders()));
            this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            if (this.receipt.isOk()) {
                List list = AJson.deserializeList(Transaction.class, jsonObject.get("data").toString());
                return list;
            }
            List<Transaction> list = null;
            return list;
        }
    }

    public Receipt getLastStatus() throws Exception {
        if (this.receipt == null) {
            return null;
        }
        return this.getStatus(this.receipt);
    }

    public Receipt getStatus(Receipt receipt) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + receipt.getNodeIp() + ":1975/v1/statuses/" + receipt.getId(), this.getHeaders()));
            Receipt receipt2 = this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            return receipt2;
        }
    }

    public String getTransactionStatus(Node node, String hash) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/transactions/" + hash, this.getHeaders()));
            String string = jsonObject.getJSONObject("data").getJSONObject("receipt").getString("status");
            return string;
        }
    }

    public String getTransactionStatusWaitUntilOk(Node node, String hash, long milliseconds) throws Exception {
        String status;
        while (!(status = this.getTransactionStatus(node, hash)).equals("Ok") && milliseconds > 0L) {
            Thread.sleep(200L);
            milliseconds -= 200L;
        }
        return status;
    }

    public String createGenesisTransactionString(Account genesisAccount, long tokens) throws Exception {
        Account fromAccount = Account.create();
        Transaction transaction = Transaction.create(fromAccount.getPrivateKey(), fromAccount.getAddress(), genesisAccount.getAddress(), (byte)0, String.valueOf(tokens), "", "", "", 0L);
        return transaction.toString();
    }

    public Receipt getStatus(Node node, String id) throws Exception {
        try (Http http = new Http();){
            JSONObject jsonObject = new JSONObject(http.get("http://" + node.getHttpEndpoint().getHost() + ":" + String.valueOf(node.getHttpEndpoint().getPort()) + "/v1/statuses/" + id, this.getHeaders()));
            Receipt receipt = this.receipt = (Receipt)AJson.deserialize(Receipt.class, jsonObject.toString());
            return receipt;
        }
    }

    private Map<String, String> getHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return headers;
    }

    public static void main(String[] args) {
        System.out.println("DSplend SDK Example");
        try {
            Sdk sdk = new Sdk("127.0.0.1");
            List<Node> nodes = sdk.getDelegates();
            Receipt receipt = sdk.transferTokens(nodes.get(0), "0f86ea981203b26b5b8244c8f661e30e5104555068a4bd168d3e3015db9bb25a", "3ed25f42484d517cdfc72cafb7ebc9e8baa52c2c", "1dcfccb29a15aa5bfb70ce944c745eb421d04bb5", 69L);
            while ((receipt = sdk.getLastStatus()).getStatus().equals("Pending")) {
                Thread.sleep(200L);
            }
            System.out.println(receipt.getStatus());
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }
}

