/*
 * Decompiled with CFR 0.152.
 */
package dsplend.crypto;

import dsplend.utils.Utils;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.asn1.sec.SECNamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.generators.ECKeyPairGenerator;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyGenerationParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;

public class Key {
    private static final ECDomainParameters ecParams;
    private static final SecureRandom secureRandom;
    private final BigInteger privateKey;
    private final byte[] publicKey;

    public Key() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(ecParams, secureRandom);
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters pubParams = (ECPublicKeyParameters)keypair.getPublic();
        this.privateKey = privParams.getD();
        this.publicKey = pubParams.getQ().getEncoded(false);
    }

    public Key(BigInteger privKey) {
        this.privateKey = privKey;
        this.publicKey = Key.publicKeyFromPrivate(privKey);
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKey;
    }

    public String getPublicKey() {
        return Utils.toHexString(this.getPublicKeyBytes());
    }

    public byte[] getPrivateKeyBytes() {
        return Utils.bigIntegerToBytes(this.privateKey, 32);
    }

    public String getPrivateKey() {
        return Utils.toHexString(this.getPrivateKeyBytes());
    }

    public static byte[] publicKeyFromPrivate(BigInteger privKey) {
        return ecParams.getG().multiply(privKey).getEncoded(false);
    }

    static {
        X9ECParameters params = SECNamedCurves.getByName((String)"secp256k1");
        ecParams = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        secureRandom = new SecureRandom();
    }
}

