/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.systemlambda;

import com.github.stefanbirkner.systemlambda.Statement;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class SystemLambda {
    private static final boolean AUTO_FLUSH = true;
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();

    public static void assertNothingWrittenToSystemErr(Statement statement) throws Exception {
        SystemLambda.executeWithSystemErrReplacement(new DisallowWriteStream(), statement);
    }

    public static void assertNothingWrittenToSystemOut(Statement statement) throws Exception {
        SystemLambda.executeWithSystemOutReplacement(new DisallowWriteStream(), statement);
    }

    public static int catchSystemExit(Statement statement) throws Exception {
        NoExitSecurityManager noExitSecurityManager = new NoExitSecurityManager(System.getSecurityManager());
        try {
            SystemLambda.withSecurityManager(noExitSecurityManager, statement);
        }
        catch (CheckExitCalled checkExitCalled) {
            // empty catch block
        }
        return SystemLambda.checkSystemExit(noExitSecurityManager);
    }

    public static void muteSystemErr(Statement statement) throws Exception {
        SystemLambda.executeWithSystemErrReplacement(new NoopStream(), statement);
    }

    public static void muteSystemOut(Statement statement) throws Exception {
        SystemLambda.executeWithSystemOutReplacement(new NoopStream(), statement);
    }

    public static void restoreSystemProperties(Statement statement) throws Exception {
        Properties originalProperties = System.getProperties();
        System.setProperties(SystemLambda.copyOf(originalProperties));
        try {
            statement.execute();
        }
        finally {
            System.setProperties(originalProperties);
        }
    }

    public static String tapSystemErr(Statement statement) throws Exception {
        TapStream tapStream = new TapStream();
        SystemLambda.executeWithSystemErrReplacement(tapStream, statement);
        return tapStream.textThatWasWritten();
    }

    public static String tapSystemErrNormalized(Statement statement) throws Exception {
        return SystemLambda.tapSystemErr(statement).replace(System.lineSeparator(), "\n");
    }

    public static String tapSystemOut(Statement statement) throws Exception {
        TapStream tapStream = new TapStream();
        SystemLambda.executeWithSystemOutReplacement(tapStream, statement);
        return tapStream.textThatWasWritten();
    }

    public static String tapSystemOutNormalized(Statement statement) throws Exception {
        return SystemLambda.tapSystemOut(statement).replace(System.lineSeparator(), "\n");
    }

    public static WithEnvironmentVariables withEnvironmentVariable(String name, String value) {
        return new WithEnvironmentVariables(Collections.singletonMap(name, value));
    }

    public static void withSecurityManager(SecurityManager securityManager, Statement statement) throws Exception {
        SecurityManager originalSecurityManager = System.getSecurityManager();
        System.setSecurityManager(securityManager);
        try {
            statement.execute();
        }
        finally {
            System.setSecurityManager(originalSecurityManager);
        }
    }

    public static SystemInStub withTextFromSystemIn(String ... lines) {
        String text = Arrays.stream(lines).map(line -> line + System.lineSeparator()).collect(Collectors.joining());
        return new SystemInStub(text);
    }

    private static Properties copyOf(Properties source) {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)source);
        return copy;
    }

    private static void executeWithSystemErrReplacement(OutputStream replacementForErr, Statement statement) throws Exception {
        PrintStream originalStream = System.err;
        try {
            System.setErr(SystemLambda.wrap(replacementForErr));
            statement.execute();
        }
        finally {
            System.setErr(originalStream);
        }
    }

    private static void executeWithSystemOutReplacement(OutputStream replacementForOut, Statement statement) throws Exception {
        PrintStream originalStream = System.out;
        try {
            System.setOut(SystemLambda.wrap(replacementForOut));
            statement.execute();
        }
        finally {
            System.setOut(originalStream);
        }
    }

    private static PrintStream wrap(OutputStream outputStream) throws UnsupportedEncodingException {
        return new PrintStream(outputStream, true, DEFAULT_ENCODING);
    }

    private static int checkSystemExit(NoExitSecurityManager securityManager) {
        if (securityManager.isCheckExitCalled()) {
            return securityManager.getStatusOfFirstCheckExitCall();
        }
        throw new AssertionError((Object)"System.exit has not been called.");
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        private final SecurityManager originalSecurityManager;
        private Integer statusOfFirstExitCall = null;

        NoExitSecurityManager(SecurityManager originalSecurityManager) {
            this.originalSecurityManager = originalSecurityManager;
        }

        @Override
        public void checkExit(int status) {
            if (this.statusOfFirstExitCall == null) {
                this.statusOfFirstExitCall = status;
            }
            throw new CheckExitCalled();
        }

        boolean isCheckExitCalled() {
            return this.statusOfFirstExitCall != null;
        }

        int getStatusOfFirstCheckExitCall() {
            if (this.isCheckExitCalled()) {
                return this.statusOfFirstExitCall;
            }
            throw new IllegalStateException("checkExit(int) has not been called.");
        }

        public boolean getInCheck() {
            return this.originalSecurityManager != null && this.originalSecurityManager.getInCheck();
        }

        @Override
        public Object getSecurityContext() {
            return this.originalSecurityManager == null ? super.getSecurityContext() : this.originalSecurityManager.getSecurityContext();
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPermission(perm, context);
            }
        }

        @Override
        public void checkCreateClassLoader() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkCreateClassLoader();
            }
        }

        @Override
        public void checkAccess(Thread t) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkAccess(t);
            }
        }

        @Override
        public void checkAccess(ThreadGroup g) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkAccess(g);
            }
        }

        @Override
        public void checkExec(String cmd) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkExec(cmd);
            }
        }

        @Override
        public void checkLink(String lib) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkLink(lib);
            }
        }

        @Override
        public void checkRead(FileDescriptor fd) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkRead(fd);
            }
        }

        @Override
        public void checkRead(String file) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkRead(file);
            }
        }

        @Override
        public void checkRead(String file, Object context) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkRead(file, context);
            }
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkWrite(fd);
            }
        }

        @Override
        public void checkWrite(String file) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkWrite(file);
            }
        }

        @Override
        public void checkDelete(String file) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkDelete(file);
            }
        }

        @Override
        public void checkConnect(String host, int port) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkConnect(host, port);
            }
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkConnect(host, port, context);
            }
        }

        @Override
        public void checkListen(int port) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkListen(port);
            }
        }

        @Override
        public void checkAccept(String host, int port) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkAccept(host, port);
            }
        }

        @Override
        public void checkMulticast(InetAddress maddr) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkMulticast(maddr);
            }
        }

        @Override
        public void checkMulticast(InetAddress maddr, byte ttl) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkMulticast(maddr, ttl);
            }
        }

        @Override
        public void checkPropertiesAccess() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPropertiesAccess();
            }
        }

        @Override
        public void checkPropertyAccess(String key) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPropertyAccess(key);
            }
        }

        public boolean checkTopLevelWindow(Object window) {
            return this.originalSecurityManager == null ? super.checkTopLevelWindow(window) : this.originalSecurityManager.checkTopLevelWindow(window);
        }

        @Override
        public void checkPrintJobAccess() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPrintJobAccess();
            }
        }

        public void checkSystemClipboardAccess() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkSystemClipboardAccess();
            }
        }

        public void checkAwtEventQueueAccess() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkAwtEventQueueAccess();
            }
        }

        @Override
        public void checkPackageAccess(String pkg) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPackageAccess(pkg);
            }
        }

        @Override
        public void checkPackageDefinition(String pkg) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkPackageDefinition(pkg);
            }
        }

        @Override
        public void checkSetFactory() {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkSetFactory();
            }
        }

        public void checkMemberAccess(Class<?> clazz, int which) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkMemberAccess(clazz, which);
            }
        }

        @Override
        public void checkSecurityAccess(String target) {
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkSecurityAccess(target);
            }
        }

        @Override
        public ThreadGroup getThreadGroup() {
            return this.originalSecurityManager == null ? super.getThreadGroup() : this.originalSecurityManager.getThreadGroup();
        }
    }

    private static class CheckExitCalled
    extends SecurityException {
        private static final long serialVersionUID = 159678654L;

        private CheckExitCalled() {
        }
    }

    public static final class WithEnvironmentVariables {
        private final Map<String, String> variables;

        private WithEnvironmentVariables(Map<String, String> variables) {
            this.variables = variables;
        }

        public WithEnvironmentVariables and(String name, String value) {
            this.validateNotSet(name, value);
            HashMap<String, String> moreVariables = new HashMap<String, String>(this.variables);
            moreVariables.put(name, value);
            return new WithEnvironmentVariables(moreVariables);
        }

        private void validateNotSet(String name, String value) {
            if (this.variables.containsKey(name)) {
                String currentValue = this.variables.get(name);
                throw new IllegalArgumentException("The environment variable '" + name + "' cannot be set to " + this.format(value) + " because it was already set to " + this.format(currentValue) + ".");
            }
        }

        private String format(String text) {
            if (text == null) {
                return "null";
            }
            return "'" + text + "'";
        }

        public void execute(Statement statement) throws Exception {
            HashMap<String, String> originalVariables = new HashMap<String, String>(System.getenv());
            try {
                this.setEnvironmentVariables();
                statement.execute();
            }
            finally {
                this.restoreOriginalVariables(originalVariables);
            }
        }

        private void setEnvironmentVariables() {
            this.overrideVariables(WithEnvironmentVariables.getEditableMapOfVariables());
            this.overrideVariables(WithEnvironmentVariables.getTheCaseInsensitiveEnvironment());
        }

        private void overrideVariables(Map<String, String> existingVariables) {
            if (existingVariables != null) {
                this.variables.forEach((name, value) -> this.set(existingVariables, (String)name, (String)value));
            }
        }

        private void set(Map<String, String> variables, String name, String value) {
            if (value == null) {
                variables.remove(name);
            } else {
                variables.put(name, value);
            }
        }

        void restoreOriginalVariables(Map<String, String> originalVariables) {
            this.restoreVariables(WithEnvironmentVariables.getEditableMapOfVariables(), originalVariables);
            this.restoreVariables(WithEnvironmentVariables.getTheCaseInsensitiveEnvironment(), originalVariables);
        }

        void restoreVariables(Map<String, String> variables, Map<String, String> originalVariables) {
            if (variables != null) {
                variables.clear();
                variables.putAll(originalVariables);
            }
        }

        private static Map<String, String> getEditableMapOfVariables() {
            Class<?> classOfMap = System.getenv().getClass();
            try {
                return WithEnvironmentVariables.getFieldValue(classOfMap, System.getenv(), "m");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("System Rules cannot access the field 'm' of the map System.getenv().", e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("System Rules expects System.getenv() to have a field 'm' but it has not.", e);
            }
        }

        private static Map<String, String> getTheCaseInsensitiveEnvironment() {
            try {
                Class<?> processEnvironment = Class.forName("java.lang.ProcessEnvironment");
                return WithEnvironmentVariables.getFieldValue(processEnvironment, null, "theCaseInsensitiveEnvironment");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("System Rules expects the existence of the class java.lang.ProcessEnvironment but it does not exist.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("System Rules cannot access the static field 'theCaseInsensitiveEnvironment' of the class java.lang.ProcessEnvironment.", e);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }

        private static Map<String, String> getFieldValue(Class<?> klass, Object object, String name) throws NoSuchFieldException, IllegalAccessException {
            Field field = klass.getDeclaredField(name);
            field.setAccessible(true);
            return (Map)field.get(object);
        }
    }

    private static class TapStream
    extends OutputStream {
        final ByteArrayOutputStream text = new ByteArrayOutputStream();

        private TapStream() {
        }

        @Override
        public void write(int b) {
            this.text.write(b);
        }

        String textThatWasWritten() {
            return this.text.toString();
        }
    }

    public static class SystemInStub {
        private IOException ioException;
        private RuntimeException runtimeException;
        private final String text;

        private SystemInStub(String text) {
            this.text = text;
        }

        public SystemInStub andExceptionThrownOnInputEnd(IOException exception) {
            if (this.runtimeException != null) {
                throw new IllegalStateException("You cannot call andExceptionThrownOnInputEnd(IOException) because andExceptionThrownOnInputEnd(RuntimeException) has already been called.");
            }
            this.ioException = exception;
            return this;
        }

        public SystemInStub andExceptionThrownOnInputEnd(RuntimeException exception) {
            if (this.ioException != null) {
                throw new IllegalStateException("You cannot call andExceptionThrownOnInputEnd(RuntimeException) because andExceptionThrownOnInputEnd(IOException) has already been called.");
            }
            this.runtimeException = exception;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Statement statement) throws Exception {
            ReplacementInputStream stubStream = new ReplacementInputStream(this.text, this.ioException, this.runtimeException);
            InputStream originalIn = System.in;
            try {
                System.setIn(stubStream);
                statement.execute();
            }
            finally {
                System.setIn(originalIn);
            }
        }

        private static class ReplacementInputStream
        extends InputStream {
            private final StringReader reader;
            private final IOException ioException;
            private final RuntimeException runtimeException;

            ReplacementInputStream(String text, IOException ioException, RuntimeException runtimeException) {
                this.reader = new StringReader(text);
                this.ioException = ioException;
                this.runtimeException = runtimeException;
            }

            @Override
            public int read() throws IOException {
                int character = this.reader.read();
                if (character == -1) {
                    this.handleEmptyReader();
                }
                return character;
            }

            private void handleEmptyReader() throws IOException {
                if (this.ioException != null) {
                    throw this.ioException;
                }
                if (this.runtimeException != null) {
                    throw this.runtimeException;
                }
            }

            @Override
            public int read(byte[] buffer, int offset, int len) throws IOException {
                if (buffer == null) {
                    throw new NullPointerException();
                }
                if (offset < 0 || len < 0 || len > buffer.length - offset) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                return this.readNextLine(buffer, offset, len);
            }

            private int readNextLine(byte[] buffer, int offset, int len) throws IOException {
                byte read;
                int i;
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buffer[offset] = (byte)c;
                for (i = 1; i < len && !this.isCompleteLineWritten(buffer, i - 1) && (read = (byte)this.read()) != -1; ++i) {
                    buffer[offset + i] = read;
                }
                return i;
            }

            private boolean isCompleteLineWritten(byte[] buffer, int indexLastByteWritten) {
                byte[] separator = System.getProperty("line.separator").getBytes(Charset.defaultCharset());
                int indexFirstByteOfSeparator = indexLastByteWritten - separator.length + 1;
                return indexFirstByteOfSeparator >= 0 && this.contains(buffer, separator, indexFirstByteOfSeparator);
            }

            private boolean contains(byte[] array, byte[] pattern, int indexStart) {
                for (int i = 0; i < pattern.length; ++i) {
                    if (array[indexStart + i] == pattern[i]) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static class NoopStream
    extends OutputStream {
        private NoopStream() {
        }

        @Override
        public void write(int b) {
        }
    }

    private static class DisallowWriteStream
    extends OutputStream {
        private DisallowWriteStream() {
        }

        @Override
        public void write(int b) {
            throw new AssertionError((Object)("Tried to write '" + (char)b + "' although this is not allowed."));
        }
    }
}

