/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.comm;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.redmine.ta.RedmineException;
import org.redmine.ta.RedmineFormatException;
import org.redmine.ta.RedmineOptions;
import org.redmine.ta.RedmineTransportException;
import org.redmine.ta.internal.comm.Communicator;
import org.redmine.ta.internal.comm.ConnectionEvictor;
import org.redmine.ta.internal.comm.ContentHandler;
import org.redmine.ta.internal.comm.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCommunicator
implements Communicator<HttpResponse> {
    private final Logger logger = LoggerFactory.getLogger(BaseCommunicator.class);
    private final HttpClient client;
    private final ConnectionEvictor evictor;

    public BaseCommunicator(RedmineOptions options) {
        DefaultHttpClient clientImpl;
        PoolingClientConnectionManager connManager;
        try {
            connManager = HttpUtil.createConnectionManager(options.getMaxOpenConnecitons());
            clientImpl = HttpUtil.getNewHttpClient((ClientConnectionManager)connManager);
        }
        catch (Exception e) {
            this.logger.warn("Could not create connection manager, falling back to default", (Throwable)e);
            connManager = null;
            clientImpl = new DefaultHttpClient();
        }
        if (connManager != null) {
            this.evictor = new ConnectionEvictor((ClientConnectionManager)connManager, options.getEvictionCheckInterval(), options.getIdleTimeout());
            this.runEvictor(this.evictor);
        } else {
            this.evictor = null;
        }
        this.client = clientImpl;
    }

    private void runEvictor(ConnectionEvictor evictor2) {
        Thread evictorThread = new Thread(evictor2);
        evictorThread.setDaemon(true);
        evictorThread.setName("Redmine communicator connection eviction thread");
        evictorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R sendRequest(HttpRequest request, ContentHandler<HttpResponse, R> handler) throws RedmineException {
        this.logger.debug(request.getRequestLine().toString());
        request.addHeader("Accept-Encoding", "gzip");
        HttpClient httpclient = this.client;
        try {
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)request);
            try {
                R r = handler.processContent(httpResponse);
                return r;
            }
            finally {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
        }
        catch (ClientProtocolException e1) {
            throw new RedmineFormatException(e1);
        }
        catch (IOException e1) {
            throw new RedmineTransportException("Cannot fetch data from " + this.getMessageURI(request) + " : " + e1.toString(), e1);
        }
    }

    private String getMessageURI(HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        int paramsIndex = uri.indexOf(63);
        if (paramsIndex >= 0) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
        if (this.evictor != null) {
            this.evictor.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.evictor != null) {
                this.evictor.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }
}

