/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.comm.redmine;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpRequest;
import org.redmine.ta.RedmineException;
import org.redmine.ta.RedmineInternalError;
import org.redmine.ta.internal.comm.Communicator;
import org.redmine.ta.internal.comm.ContentHandler;

public class RedmineAuthenticator<K>
implements Communicator<K> {
    private String authKey;
    private final String charset;
    private final Communicator<K> peer;

    public RedmineAuthenticator(Communicator<K> peer, String charset) {
        this.peer = peer;
        this.charset = charset;
    }

    public void setCredentials(String login, String password) {
        if (login == null) {
            this.authKey = null;
            return;
        }
        try {
            this.authKey = "Basic: \"" + Base64.encodeBase64String((byte[])(login + ':' + password).getBytes(this.charset)).trim() + "\"";
        }
        catch (UnsupportedEncodingException e) {
            throw new RedmineInternalError(e);
        }
    }

    @Override
    public <R> R sendRequest(HttpRequest request, ContentHandler<K, R> handler) throws RedmineException {
        if (this.authKey != null) {
            request.addHeader("Authorization", this.authKey);
        }
        return this.peer.sendRequest(request, handler);
    }
}

