/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.redmine.ta.internal.json.JsonObjectParser;

public class JsonInput {
    public static <T> List<T> getListNotNull(JSONObject obj, String field, JsonObjectParser<T> parser) throws JSONException {
        JSONArray items = JsonInput.getArrayNotNull(obj, field);
        int length = items.length();
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            result.add(parser.parse(items.getJSONObject(i)));
        }
        return result;
    }

    public static <T> List<T> getListOrNull(JSONObject obj, String field, JsonObjectParser<T> parser) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        JSONArray items = obj.getJSONArray(field);
        int length = items.length();
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            result.add(parser.parse(items.getJSONObject(i)));
        }
        return result;
    }

    public static <T> List<T> getListOrEmpty(JSONObject obj, String field, JsonObjectParser<T> parser) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return new ArrayList();
        }
        JSONArray items = obj.getJSONArray(field);
        if (items == null) {
            return new ArrayList();
        }
        int length = items.length();
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            result.add(parser.parse(items.getJSONObject(i)));
        }
        return result;
    }

    public static Date getDateOrNull(JSONObject obj, String field, SimpleDateFormat dateFormat) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        String guess = obj.getString(field);
        try {
            return dateFormat.parse(guess);
        }
        catch (ParseException e) {
            try {
                return JsonInput.getISO8610DateOrNull(guess);
            }
            catch (ParseException e1) {
                try {
                    return JsonInput.getISO8610ShortDateOrNull(guess);
                }
                catch (ParseException e2) {
                    throw new JSONException("Bad date value " + guess);
                }
            }
        }
    }

    private static Date getISO8610DateOrNull(String input) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (input.endsWith("Z")) {
            input = input.substring(0, input.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input = s0 + "GMT" + s1;
        }
        return df.parse(input);
    }

    private static Date getISO8610ShortDateOrNull(String input) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.parse(input);
    }

    public static String getStringOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return obj.getString(field);
    }

    public static String getStringOrEmpty(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return "";
        }
        return obj.getString(field);
    }

    public static String getStringNotNull(JSONObject obj, String field) throws JSONException {
        return obj.getString(field);
    }

    public static int getInt(JSONObject obj, String field) throws JSONException {
        return obj.getInt(field);
    }

    public static int getInt(JSONObject obj, String field, int deflt) throws JSONException {
        return obj.optInt(field, deflt);
    }

    public static Integer getIntOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return obj.getInt(field);
    }

    public static long getLong(JSONObject obj, String field) throws JSONException {
        return obj.getLong(field);
    }

    public static Long getLongOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return obj.getLong(field);
    }

    public static Float getFloatOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return Float.valueOf((float)obj.getDouble(field));
    }

    public static <T> T getObjectOrNull(JSONObject obj, String field, JsonObjectParser<T> parser) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return parser.parse(obj.getJSONObject(field));
    }

    public static JSONArray getArrayOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return obj.getJSONArray(field);
    }

    public static JSONArray getArrayNotNull(JSONObject obj, String field) throws JSONException {
        return obj.getJSONArray(field);
    }

    public static JSONObject getObjectNotNull(JSONObject obj, String field) throws JSONException {
        return obj.getJSONObject(field);
    }

    public static JSONObject getObjectOrNull(JSONObject obj, String field) throws JSONException {
        if (!obj.has(field) || obj.isNull(field)) {
            return null;
        }
        return obj.getJSONObject(field);
    }
}

