/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.redmine.ta.internal.RedmineDateHandler;

public class RedmineLongDateHandler
extends RedmineDateHandler {
    private static final String FORMAT_REDMINE_1_1 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final int SHIFT = 3;

    @Override
    public Date getDate(String str) throws ParseException {
        String converted = this.convertToRFC822Format(str);
        return formatter.parse(converted);
    }

    private String convertToRFC822Format(String str) {
        StringBuilder b = new StringBuilder();
        b.append(str.substring(0, str.length() - 3));
        b.append(str.substring(str.length() - 3 + 1));
        return b.toString();
    }

    private String convertToRedmine11Format(String str) {
        StringBuilder b = new StringBuilder();
        b.append(str.substring(0, str.length() - 3 + 1));
        b.append(":");
        b.append(str.substring(str.length() - 3 + 1));
        return b.toString();
    }

    @Override
    public String getString(Date date) {
        String rfcFormat = formatter.format(date);
        return this.convertToRedmine11Format(rfcFormat);
    }
}

