/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.processor;

import com.github.structlogging.LoggingEvent;
import com.github.structlogging.StructLogger;
import com.github.structlogging.VariableContext;
import com.github.structlogging.annotation.LoggerContext;
import com.github.structlogging.annotation.Var;
import com.github.structlogging.annotation.VarContextProvider;
import com.github.structlogging.processor.LogInvocationScanner;
import com.github.structlogging.processor.LogLevel;
import com.github.structlogging.processor.SchemaGenerator;
import com.github.structlogging.processor.exception.PackageNameException;
import com.github.structlogging.processor.utils.GeneratedClassInfo;
import com.github.structlogging.processor.utils.ScannerParams;
import com.github.structlogging.processor.utils.StructLoggerFieldContext;
import com.github.structlogging.processor.utils.Variable;
import com.github.structlogging.processor.utils.VariableContextProvider;
import com.google.auto.service.AutoService;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"*"})
@AutoService(value=Processor.class)
public class LogInvocationProcessor
extends AbstractProcessor {
    private final Set<TypeMirror> varContextProviders = new HashSet<TypeMirror>();
    private final Map<TypeMirror, VariableContextProvider> varsHashMap = new HashMap<TypeMirror, VariableContextProvider>();
    private final Set<GeneratedClassInfo> generatedClassesInfo = new HashSet<GeneratedClassInfo>();
    private Trees trees;
    private Messager messager;
    private Types types;
    private Elements elements;
    private LogInvocationScanner logInvocationScanner;
    private boolean initFailed = false;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.trees = Trees.instance(processingEnv);
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        try {
            this.logInvocationScanner = new LogInvocationScanner(processingEnv);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "IOException caught");
            this.initFailed = true;
        }
        catch (PackageNameException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "generatedEventsPackage compiler argument is not valid, either it contains java keyword or subpackage or class name starts with number");
            this.initFailed = true;
        }
        String schemasRoot = processingEnv.getOptions().get("schemasRoot");
        if (schemasRoot != null) {
            try {
                new URI(schemasRoot);
            }
            catch (URISyntaxException e) {
                this.initFailed = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Provided schemasRoot compiler argument value [%s] is not valid path", schemasRoot));
            }
            SchemaGenerator schemaGenerator = new SchemaGenerator(this.generatedClassesInfo, schemasRoot);
            JavacTask.instance(processingEnv).addTaskListener(schemaGenerator);
        } else {
            this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "schemasRoot compiler argument is not set, no schemas will be created");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.initFailed) {
            return false;
        }
        this.processStructLogExpressions(roundEnv);
        return false;
    }

    private boolean checkVarContextProvider(TypeMirror typeMirror) {
        TypeElement element = (TypeElement)this.types.asElement(typeMirror);
        if (this.varContextProviders.contains(typeMirror)) {
            return true;
        }
        if (!element.getKind().isInterface()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should be interface", element), element);
            return false;
        }
        boolean extendsVariableContext = this.extendsVariableContext(element);
        if (!extendsVariableContext) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should be extending %s", element, VariableContext.class.getName()), element);
            return false;
        }
        ArrayList<Variable> elements = new ArrayList<Variable>();
        VarContextProvider varContextProvider = element.getAnnotation(VarContextProvider.class);
        if (varContextProvider == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should be annotated with @VarContextProvider", element), element);
            return false;
        }
        for (Element element2 : element.getEnclosedElements()) {
            Name simpleName;
            ExecutableType executableType;
            block13: {
                block12: {
                    Var annotation = element2.getAnnotation(Var.class);
                    if (annotation == null) continue;
                    executableType = (ExecutableType)element2.asType();
                    simpleName = element2.getSimpleName();
                    List logLevelsMethodNames = Arrays.stream(LogLevel.values()).map(LogLevel::getLevelMethodName).collect(Collectors.toList());
                    List logEventMethodNames = Arrays.stream(LogLevel.values()).map(LogLevel::getLogEventMethodName).collect(Collectors.toList());
                    List loggingEventFieldNames = Arrays.stream(LoggingEvent.class.getDeclaredFields()).map(e -> e.getName()).collect(Collectors.toList());
                    if (simpleName.contentEquals("log")) break block12;
                    if (logLevelsMethodNames.stream().anyMatch(simpleName::contentEquals)) break block12;
                    if (logEventMethodNames.stream().anyMatch(simpleName::contentEquals)) break block12;
                    if (!loggingEventFieldNames.stream().anyMatch(simpleName::contentEquals)) break block13;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s interface cannot have method named %s", element, simpleName), element);
                return false;
            }
            if (!executableType.getReturnType().toString().equals(typeMirror.toString())) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s.%s method must have return type %s", element, simpleName, element), element);
                return false;
            }
            if (executableType.getParameterTypes().size() != 1) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s.%s method must have exactly one argument", element, simpleName), element);
                return false;
            }
            if (elements.stream().map(Variable::getName).anyMatch(e -> e.contentEquals(simpleName))) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s.%s method cannot be overloaded", element, simpleName), element);
                return false;
            }
            elements.add(new Variable(simpleName, executableType.getParameterTypes().get(0)));
        }
        if (elements.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("%s has no @Var annotated methods", element), element);
        }
        this.varsHashMap.put(typeMirror, new VariableContextProvider(typeMirror, elements, varContextProvider.parametrization()));
        this.varContextProviders.add(typeMirror);
        return true;
    }

    private boolean extendsVariableContext(TypeElement typeElement) {
        boolean extendsVariableContext = false;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!typeMirror.toString().equals(VariableContext.class.getCanonicalName())) continue;
            extendsVariableContext = true;
        }
        return extendsVariableContext;
    }

    private void processStructLogExpressions(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            HashMap<Name, StructLoggerFieldContext> fields = new HashMap<Name, StructLoggerFieldContext>();
            for (Element element2 : element.getEnclosedElements()) {
                TypeMirror typeMirrorOfStructlogger;
                LoggerContext annotation;
                if (!element2.getKind().isField() || (annotation = element2.getAnnotation(LoggerContext.class)) == null) continue;
                TypeMirror typeMirrorOfField = element2.asType();
                if (!this.types.isSubtype(typeMirrorOfField, this.types.erasure(typeMirrorOfStructlogger = this.elements.getTypeElement(StructLogger.class.getCanonicalName()).asType()))) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("field %s in %s should be of type StructLogger", element2, element), element2);
                    return;
                }
                try {
                    annotation.context();
                }
                catch (MirroredTypeException ex) {
                    TypeMirror contextProviderTypeMirror = ex.getTypeMirror();
                    List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirrorOfField).getTypeArguments();
                    if (typeArguments.size() != 1) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Expected 1 type argument specified in field %s in %s", element2, element), element2);
                        return;
                    }
                    if (!this.types.isSameType(typeArguments.get(0), contextProviderTypeMirror)) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Generic type of field %s in class %s differs from type specified in @LoggerContext annotation", element2, element), element2);
                        return;
                    }
                    if (!this.checkVarContextProvider(contextProviderTypeMirror)) {
                        return;
                    }
                    fields.put(element2.getSimpleName(), new StructLoggerFieldContext(contextProviderTypeMirror));
                }
            }
            TypeElement typeElement = (TypeElement)element;
            TreePath treePath = this.trees.getPath(element);
            if (fields.isEmpty()) continue;
            this.logInvocationScanner.scan(treePath, new ScannerParams(typeElement, treePath.getCompilationUnit(), this.varsHashMap, fields, this.generatedClassesInfo));
        }
    }
}

