/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.processor;

import com.github.structlogging.processor.LogLevel;
import com.github.structlogging.processor.exception.PackageNameException;
import com.github.structlogging.processor.service.POJOService;
import com.github.structlogging.processor.utils.GeneratedClassInfo;
import com.github.structlogging.processor.utils.MethodAndParameter;
import com.github.structlogging.processor.utils.ScannerParams;
import com.github.structlogging.processor.utils.StatementInfo;
import com.github.structlogging.processor.utils.StructLoggerFieldContext;
import com.github.structlogging.processor.utils.Variable;
import com.github.structlogging.processor.utils.VariableAndValue;
import com.github.structlogging.processor.utils.VariableContextProvider;
import com.github.structlogging.utils.MessageFormatterUtils;
import com.github.structlogging.utils.SidCounter;
import com.squareup.javapoet.JavaFile;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public class LogInvocationScanner
extends TreePathScanner<Object, ScannerParams> {
    private final TreeMaker treeMaker;
    private final JavacElements elementUtils;
    private final Names names;
    private final POJOService pojoService;
    private final Messager messager;

    public LogInvocationScanner(ProcessingEnvironment processingEnvironment) throws IOException, PackageNameException {
        Context context = ((JavacProcessingEnvironment)processingEnvironment).getContext();
        this.treeMaker = TreeMaker.instance(context);
        this.elementUtils = (JavacElements)processingEnvironment.getElementUtils();
        this.messager = processingEnvironment.getMessager();
        String generatedEventsPackage = processingEnvironment.getOptions().get("generatedEventsPackage");
        this.pojoService = new POJOService(processingEnvironment.getFiler(), generatedEventsPackage);
        this.names = Names.instance(context);
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatementTree node, final ScannerParams scannerParams) {
        JCTree.JCExpressionStatement statement = (JCTree.JCExpressionStatement)this.getCurrentPath().getLeaf();
        final StatementInfo statementInfo = new StatementInfo(scannerParams.getCompilationUnitTree().getLineMap().getLineNumber(statement.pos), scannerParams.getTypeElement().getQualifiedName().toString(), statement);
        TreePathScanner<Object, ScannerParams> scanner = new TreePathScanner<Object, ScannerParams>(){
            Stack<MethodAndParameter> stack = new Stack();

            @Override
            public Object visitMethodInvocation(MethodInvocationTree node, ScannerParams o) {
                if (node.getMethodSelect() instanceof JCTree.JCFieldAccess) {
                    try {
                        JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)node.getMethodSelect();
                        ExpressionTree parameter = null;
                        if (!node.getArguments().isEmpty()) {
                            parameter = node.getArguments().get(0);
                        }
                        this.stack.add(new MethodAndParameter(methodSelect.name, parameter));
                        LogInvocationScanner.this.handle(methodSelect, this.stack, node, statementInfo, scannerParams);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return super.visitMethodInvocation(node, o);
            }
        };
        scanner.scan(this.getCurrentPath(), scannerParams);
        return super.visitExpressionStatement(node, scannerParams);
    }

    private void handle(JCTree.JCFieldAccess fieldAccess, Stack<MethodAndParameter> stack, MethodInvocationTree node, StatementInfo statementInfo, ScannerParams scannerParams) {
        if (fieldAccess.getExpression().getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
            MemberSelectTree expression = (MemberSelectTree)((Object)fieldAccess.getExpression());
            javax.lang.model.element.Name name = expression.getIdentifier();
            if (scannerParams.getFields().containsKey(name)) {
                this.handleStructLogExpression(stack, node, name, statementInfo, scannerParams);
            }
        } else if (fieldAccess.getExpression().getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
            JCTree.JCIdent ident = (JCTree.JCIdent)fieldAccess.getExpression();
            Name name = ident.getName();
            if (scannerParams.getFields().containsKey(name)) {
                this.handleStructLogExpression(stack, node, name, statementInfo, scannerParams);
            }
        }
    }

    private void handleStructLogExpression(Stack<MethodAndParameter> stack, MethodInvocationTree node, javax.lang.model.element.Name name, StatementInfo statementInfo, ScannerParams scannerParams) {
        JavaFile javaFile;
        int countOfStringVariables;
        ArrayList<VariableAndValue> usedVariables = new ArrayList<VariableAndValue>();
        JCTree.JCLiteral literal = null;
        String level = null;
        String eventName = null;
        StructLoggerFieldContext structLoggerFieldContext = scannerParams.getFields().get(name);
        TypeMirror typeMirror = structLoggerFieldContext.getContextProvider();
        VariableContextProvider variableContextProvider = scannerParams.getVarsHashMap().get(typeMirror);
        while (!stack.empty()) {
            boolean matched = false;
            MethodAndParameter top = stack.pop();
            block3: for (Variable variable : variableContextProvider.getVariables()) {
                javax.lang.model.element.Name topMethodName = top.getMethodName();
                if (variable.getName().equals(topMethodName)) {
                    this.addToUsedVariables(usedVariables, top, variable);
                    matched = true;
                    break;
                }
                for (LogLevel logLevel : LogLevel.values()) {
                    if (topMethodName.contentEquals(logLevel.getLevelMethodName())) {
                        if (!(node.getArguments().get(0) instanceof JCTree.JCLiteral)) {
                            this.printStatementMustHaveStringLiteralError(statementInfo, topMethodName);
                            return;
                        }
                        literal = (JCTree.JCLiteral)node.getArguments().get(0);
                        level = logLevel.getLevelName();
                        matched = true;
                        continue block3;
                    }
                    if (!topMethodName.contentEquals(logLevel.getLogEventMethodName())) continue;
                    return;
                }
            }
            if (top.getMethodName().contentEquals("log") && top.getParameter() != null) {
                if (!(top.getParameter() instanceof JCTree.JCLiteral)) {
                    this.printStatementMustHaveStringLiteralError(statementInfo, top.getMethodName());
                    return;
                }
                eventName = ((JCTree.JCLiteral)top.getParameter()).getValue().toString();
                if (!Pattern.compile("^(\\w+(\\.\\w+)*)+$").matcher(eventName).matches()) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("qualified event name %s specified by %s statement is not valid", statementInfo, eventName, statementInfo.getStatement()));
                    return;
                }
                matched = true;
            } else if (top.getMethodName().contentEquals("log") && top.getParameter() == null) {
                matched = true;
            }
            if (stack.empty() && !top.getMethodName().contentEquals("log")) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("statement %s must be ended by calling log() method", statementInfo, statementInfo.getStatement()));
                return;
            }
            if (matched) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("variable %s in statement %s is not specified by variable context %s", statementInfo, top.getMethodName(), statementInfo.getStatement(), variableContextProvider.getTypeMirror()));
            return;
        }
        if (variableContextProvider.shouldParametrize() && (countOfStringVariables = StringUtils.countMatches((CharSequence)literal.getValue().toString(), (CharSequence)"{}")) != usedVariables.size()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("literal %s contains %d variables, but statement %s uses %d variables", statementInfo, literal.getValue().toString(), countOfStringVariables, statementInfo.getStatement(), usedVariables.size()));
            return;
        }
        try {
            javaFile = this.pojoService.createPojo(eventName, literal, usedVariables);
        }
        catch (PackageNameException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("qualified event name %s generated by statement %s is not valid, please check specified event name and package does not contain java keyword or no subpackage or class name starts with number", statementInfo, eventName, statementInfo.getStatement()));
            return;
        }
        String className = javaFile.typeSpec.name;
        String qualifiedName = StringUtils.isBlank((CharSequence)javaFile.packageName) ? className : javaFile.packageName + "." + className;
        GeneratedClassInfo generatedClassInfo = new GeneratedClassInfo(qualifiedName, className, (String)literal.getValue(), usedVariables, javaFile.packageName);
        for (GeneratedClassInfo info : scannerParams.getGeneratedClassesInfo()) {
            if (!info.getQualifiedName().equals(generatedClassInfo.getQualifiedName()) || info.getUsedVariables().equals(generatedClassInfo.getUsedVariables())) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("Statement %s generates different event structure for same event name", statementInfo, statementInfo.getStatement()));
            return;
        }
        scannerParams.getGeneratedClassesInfo().add(generatedClassInfo);
        this.pojoService.writeJavaFile(javaFile);
        this.replaceInCode(name.toString(), generatedClassInfo, statementInfo, usedVariables, literal, level, variableContextProvider);
    }

    private void printStatementMustHaveStringLiteralError(StatementInfo statementInfo, javax.lang.model.element.Name topMethodName) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, this.formatWithStatementLocation("method %s in %s statement must have String literal as argument", statementInfo, topMethodName, statementInfo.getStatement()));
    }

    private String formatWithStatementLocation(String format, StatementInfo statementInfo, Object ... args) {
        return String.format(format, args) + String.format(" [%s:%s]", statementInfo.getSourceFileName(), statementInfo.getLineNumber());
    }

    private void addToUsedVariables(java.util.List<VariableAndValue> usedVariables, MethodAndParameter top, Variable variable) {
        VariableAndValue variableAndValue = new VariableAndValue(variable, top.getParameter());
        if (!usedVariables.contains(variableAndValue)) {
            usedVariables.add(variableAndValue);
        } else {
            int i = 0;
            while (usedVariables.contains(variableAndValue = new VariableAndValue(new Variable(this.elementUtils.getName(variable.getName().toString() + ++i), variable.getType()), top.getParameter()))) {
            }
            usedVariables.add(variableAndValue);
        }
    }

    private void replaceInCode(String loggerName, GeneratedClassInfo generatedClassInfo, StatementInfo statementInfo, java.util.List<VariableAndValue> usedVariables, JCTree.JCLiteral literal, String level, VariableContextProvider variableContextProvider) {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        Class<SidCounter> sidCounterClass = SidCounter.class;
        if (variableContextProvider.shouldParametrize()) {
            listBuffer.add(this.createFormatCall(usedVariables, literal));
        } else {
            listBuffer.add(literal);
        }
        listBuffer.add(this.treeMaker.Literal(statementInfo.getSourceFileName()));
        listBuffer.add(this.treeMaker.Literal(statementInfo.getLineNumber()));
        listBuffer.add(this.treeMaker.Literal(generatedClassInfo.getQualifiedName()));
        listBuffer.add(this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString(sidCounterClass.getPackage().getName())), this.names.fromString(sidCounterClass.getSimpleName())), this.names.fromString("incrementAndGet")), List.nil()));
        listBuffer.add(this.treeMaker.Literal(level));
        listBuffer.add(this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString(System.class.getPackage().getName())), this.names.fromString(System.class.getSimpleName())), this.names.fromString("currentTimeMillis")), List.nil()));
        this.addVariablesToBuffer(usedVariables, listBuffer);
        JCTree.JCNewClass jcNewClass = this.treeMaker.NewClass(null, List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString(generatedClassInfo.getPackageName())), this.names.fromString(generatedClassInfo.getSimpleName())), listBuffer.toList(), null);
        JCTree.JCMethodInvocation apply = this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.elementUtils.getName(loggerName)), this.elementUtils.getName(level.toLowerCase() + "Event")), List.of(jcNewClass));
        statementInfo.getStatement().expr = apply;
    }

    private JCTree.JCMethodInvocation createFormatCall(java.util.List<VariableAndValue> usedVariables, JCTree.JCLiteral literal) {
        ListBuffer<JCTree.JCLiteral> lb = new ListBuffer<JCTree.JCLiteral>();
        lb.add(literal);
        this.addVariablesToBuffer(usedVariables, lb);
        Class<MessageFormatterUtils> messageFormatterUtilsClass = MessageFormatterUtils.class;
        return this.treeMaker.Apply(List.nil(), this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.names.fromString(messageFormatterUtilsClass.getPackage().getName())), this.names.fromString(messageFormatterUtilsClass.getSimpleName())), this.names.fromString("format")), lb.toList());
    }

    private void addVariablesToBuffer(java.util.List<VariableAndValue> usedVariables, ListBuffer listBuffer) {
        for (VariableAndValue variableAndValue : usedVariables) {
            listBuffer.add(variableAndValue.getValue());
        }
    }
}

