/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.slf4j;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.structlogging.LoggingCallback;
import com.github.structlogging.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.MarkerFactory;

public class Slf4jLoggingCallback
implements LoggingCallback {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String AUDIT = "AUDIT";
    private final Logger logger;

    public Slf4jLoggingCallback(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void info(LoggingEvent e) {
        try {
            this.logger.info(this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    @Override
    public void warn(LoggingEvent e) {
        try {
            this.logger.warn(this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    @Override
    public void debug(LoggingEvent e) {
        try {
            this.logger.debug(this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    @Override
    public void error(LoggingEvent e) {
        try {
            this.logger.error(this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    @Override
    public void trace(LoggingEvent e) {
        try {
            this.logger.trace(this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    @Override
    public void audit(LoggingEvent e) {
        try {
            this.logger.info(MarkerFactory.getMarker((String)AUDIT), this.serialize(e));
        }
        catch (Exception ex) {
            throw new RuntimeException("unable to serialize event", ex);
        }
    }

    private String serialize(LoggingEvent e) throws JsonProcessingException {
        return MAPPER.writeValueAsString((Object)e);
    }
}

