/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.kafka;

import com.github.structlogging.LoggingCallback;
import com.github.structlogging.LoggingEvent;
import java.util.function.Function;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class EventTypeAwareKafkaCallback
implements LoggingCallback {
    private final Producer<Long, LoggingEvent> producer;
    private final Function<String, String> eventTypeToTopicMapping;

    public EventTypeAwareKafkaCallback(Producer<Long, LoggingEvent> producer) {
        this(producer, e -> e);
    }

    public EventTypeAwareKafkaCallback(Producer<Long, LoggingEvent> producer, Function<String, String> eventTypeToTopicMapping) {
        this.producer = producer;
        this.eventTypeToTopicMapping = eventTypeToTopicMapping;
    }

    @Override
    public void info(LoggingEvent e) {
        this.sendEvent(e);
    }

    @Override
    public void warn(LoggingEvent e) {
        this.sendEvent(e);
    }

    @Override
    public void debug(LoggingEvent e) {
        this.sendEvent(e);
    }

    @Override
    public void error(LoggingEvent e) {
        this.sendEvent(e);
    }

    @Override
    public void trace(LoggingEvent e) {
        this.sendEvent(e);
    }

    @Override
    public void audit(LoggingEvent e) {
        this.sendEvent(e);
    }

    private void sendEvent(LoggingEvent e) {
        long time = System.currentTimeMillis();
        ProducerRecord record = new ProducerRecord(this.eventTypeToTopicMapping.apply(e.getType()), (Object)time, (Object)e);
        this.producer.send(record);
    }
}

