/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.github.structlogging.processor.utils.GeneratedClassInfo;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SchemaGenerator
implements TaskListener {
    private static final String SCHEMA_04 = "http://json-schema.org/draft-04/schema#";
    private static final String JSON_SUFFIX = ".json";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(this.objectMapper);
    private final Set<GeneratedClassInfo> eventsClassInfo;
    private final String schemasRoot;

    public SchemaGenerator(Set<GeneratedClassInfo> eventsClassInfo, String schemasRoot) {
        this.eventsClassInfo = eventsClassInfo;
        this.schemasRoot = schemasRoot;
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        Iterator<GeneratedClassInfo> iterator = this.eventsClassInfo.iterator();
        while (iterator.hasNext()) {
            GeneratedClassInfo generatedGeneratedClassInfo = iterator.next();
            try {
                Class<?> clazz = Class.forName(generatedGeneratedClassInfo.getQualifiedName());
                JsonSchema schema = this.schemaGen.generateSchema(clazz);
                schema.set$schema(SCHEMA_04);
                schema.setDescription(generatedGeneratedClassInfo.getDescription());
                schema.asObjectSchema().setTitle(generatedGeneratedClassInfo.getQualifiedName());
                iterator.remove();
                this.createSchemaFile(generatedGeneratedClassInfo.getPackageName(), generatedGeneratedClassInfo.getSimpleName(), schema);
            }
            catch (Exception exception) {}
        }
    }

    private void createSchemaFile(String namespace, String signature, JsonSchema schema) {
        try {
            String dir = this.getDir(namespace);
            Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
            FileOutputStream out = new FileOutputStream(dir + signature + JSON_SUFFIX);
            out.write(this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)schema));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getDir(String namespace) {
        String pathWithoutNamespace = this.schemasRoot + File.separator + "schemas" + File.separator + "events" + File.separator;
        if (!StringUtils.isBlank((CharSequence)namespace)) {
            return pathWithoutNamespace + namespace.replace(".", File.separator) + File.separator;
        }
        return pathWithoutNamespace;
    }
}

