/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlogging.processor.service;

import com.github.structlogging.LoggingEvent;
import com.github.structlogging.processor.exception.PackageNameException;
import com.github.structlogging.processor.utils.VariableAndValue;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class POJOService {
    private static final String PACKAGE_NAME = "structlogger.generated";
    private final Filer filer;
    private String generatedEventsPackage;
    private List<String> javaKeywords;

    public POJOService(Filer filer, String generatedEventsPackage) throws IOException, PackageNameException {
        this.filer = filer;
        this.generatedEventsPackage = StringUtils.isBlank((CharSequence)generatedEventsPackage) ? PACKAGE_NAME : generatedEventsPackage;
        try (InputStream resource = POJOService.class.getResourceAsStream("/file/javakeywords.txt");){
            this.javaKeywords = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
        }
        for (String s : this.generatedEventsPackage.split("\\.")) {
            this.checkStringIsValidName(s);
        }
    }

    public JavaFile createPojo(String name, JCTree.JCLiteral literal, List<VariableAndValue> usedVariables) throws PackageNameException {
        String packageName;
        String eventName;
        if (name != null) {
            String[] split = name.split("\\.");
            eventName = split[split.length - 1];
            this.checkStringIsValidName(eventName);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < split.length - 1; ++i) {
                if (i != 0) {
                    stringBuffer.append(".");
                }
                stringBuffer.append(split[i]);
                this.checkStringIsValidName(split[i]);
            }
            packageName = stringBuffer.toString();
        } else {
            eventName = "Event" + this.hash(literal.getValue().toString());
            packageName = this.generatedEventsPackage;
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)eventName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(TypeName.get(LoggingEvent.class));
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addCommonLoggingEventFieldsToConstructor(constructorBuilder);
        for (VariableAndValue variableAndValue : usedVariables) {
            this.addPojoField(classBuilder, constructorBuilder, variableAndValue.getVariable().getName().toString(), TypeName.get((TypeMirror)variableAndValue.getVariable().getType()));
        }
        TypeSpec build = classBuilder.addMethod(constructorBuilder.build()).build();
        return JavaFile.builder((String)packageName, (TypeSpec)build).build();
    }

    private void checkStringIsValidName(String s) throws PackageNameException {
        boolean packageContainsJavaKeyword = this.javaKeywords.stream().anyMatch(s::equals);
        if (packageContainsJavaKeyword || s.matches("\\d.*")) {
            throw new PackageNameException("string is not valid");
        }
    }

    private void addCommonLoggingEventFieldsToConstructor(MethodSpec.Builder constructorBuilder) {
        constructorBuilder.addParameter(TypeName.get(String.class), "message", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.get(String.class), "sourceFile", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.LONG, "lineNumber", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.get(String.class), "type", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.LONG, "sid", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.get(String.class), "logLevel", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addParameter(TypeName.LONG, "timestamp", new Modifier[]{Modifier.FINAL});
        constructorBuilder.addCode("super(message,sourceFile,lineNumber,type,sid,logLevel,timestamp);", new Object[0]);
    }

    public void writeJavaFile(JavaFile javaFile) {
        try {
            javaFile.writeTo(this.filer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addPojoField(TypeSpec.Builder classBuilder, MethodSpec.Builder constructorBuilder, String fieldName, TypeName fieldClass) {
        classBuilder.addField(fieldClass, fieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        this.addGetter(classBuilder, fieldName, fieldClass);
        this.addConstructorParameter(constructorBuilder, fieldName, fieldClass);
    }

    private void addConstructorParameter(MethodSpec.Builder constructorBuilder, String attributeName, TypeName type) {
        constructorBuilder.addParameter(type, attributeName, new Modifier[]{Modifier.FINAL});
        constructorBuilder.addCode("this." + attributeName + "=" + attributeName + ";", new Object[0]);
    }

    private void addGetter(TypeSpec.Builder classBuilder, String attributeName, TypeName type) {
        String getterMethodName = "get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)getterMethodName);
        getterBuilder.returns(type);
        getterBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        getterBuilder.addCode("return this." + attributeName + ";", new Object[0]);
        classBuilder.addMethod(getterBuilder.build());
    }

    private String hash(String string) {
        String sha1Hex = DigestUtils.sha1Hex((String)string);
        return StringUtils.substring((String)sha1Hex, (int)0, (int)8);
    }
}

