/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundev79.MineBootFramework.MineBootShell;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.AnsiFormat;
import com.diogonunes.jcolor.Attribute;
import com.github.sundev79.MineBootFramework.MineBootShell.MineBootCommand;
import com.sunproject.minebootApi.api.MineBootModuleType;
import com.sunproject.minebootApi.api.events.MineBootEventHandler;
import com.sunproject.minebootApi.api.init.MineBootAPiInit;
import com.sunproject.minebootApi.api.providers.modulemanager.MineBootModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class MineBootShell
extends MineBootModule {
    private static final String moduleName = "MineBootShell";
    private Scanner cliListener;
    private MineBootEventHandler preInitTaskEvent;
    private String prompt = Ansi.colorize((String)MineBootAPiInit.getVersion().getName(), (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.CYAN_TEXT(), Attribute.ITALIC()})) + ":" + Ansi.colorize((String)"~", (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.RED_TEXT()})) + Ansi.colorize((String)">", (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.BOLD(), Attribute.ITALIC()})) + " ";
    private static Thread shellThread;
    private String[] args;
    private List<String> cmdArgs;

    public MineBootShell(MineBootEventHandler preInitTask) {
        super(moduleName, MineBootModuleType.ModuleType.BASIC, 1L);
        this.preInitTaskEvent = preInitTask;
        this.cliListener = new Scanner(System.in);
        shellThread = new Thread(() -> {
            System.out.println("\n");
            this.callInterpreter(this.prompt);
        });
        shellThread.setName("MineBootShell_MainThread");
    }

    private void callInterpreter(String prompt) {
        while (true) {
            System.out.print(prompt);
            this.args = this.cliListener.nextLine().split(" ");
            this.cmdArgs = new ArrayList<String>(Arrays.asList(this.args));
            this.sendCommand(this.args);
        }
    }

    private synchronized void sendCommand(String[] cmdName) {
        if (!cmdName[0].isEmpty()) {
            if (MineBootCommand.getCommands().get(cmdName[0]) == null) {
                System.err.println("\nCommand \"" + cmdName[0] + "\" not found !");
            } else {
                MineBootCommand command = MineBootCommand.getCommands().get(cmdName[0]);
                if (cmdName.length > 1) {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(cmdName));
                    list.remove(0);
                    command.setCommandArgs(list);
                }
                command.launchCommand();
                command.setCommandArgs(null);
            }
        }
    }

    public void onEnable() {
        if (this.preInitTaskEvent != null) {
            this.preInitTaskEvent.onEvent();
        }
        shellThread.start();
    }

    public void onDisable() {
        MineBootCommand.unregisterAllCommands();
        shellThread.stop();
    }
}

