/*
 * Decompiled with CFR 0.152.
 */
package com.github.sundev79.MineBootFramework.MineBootShell;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.AnsiFormat;
import com.diogonunes.jcolor.Attribute;
import com.github.sundev79.MineBootFramework.MineBootShell.MineBootCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.MineBootAboutShellInfoCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.MineBootHelpCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.core.MineBootCdCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.core.MineBootMkdirCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.core.MineBootPwdCommand;
import com.github.sundev79.MineBootFramework.MineBootShell.builtin.core.MineBootRmCommand;
import com.github.sundev79.MineBootFramework.MineBootframework.api.MineBootModuleType;
import com.github.sundev79.MineBootFramework.MineBootframework.api.events.MineBootEventHandler;
import com.github.sundev79.MineBootFramework.MineBootframework.api.providers.modulemanager.MineBootModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;

public class MineBootShell
extends MineBootModule {
    private static final String moduleName = "MineBootShell";
    private static final String moduleVersion = "1.1.2";
    private final Scanner cliListener;
    private final MineBootEventHandler preInitTaskEvent;
    private static File pwdFile;
    private static boolean coreUtilsEnabled;
    private String prompt = Ansi.colorize((String)"~", (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.RED_TEXT()})) + Ansi.colorize((String)">", (AnsiFormat)new AnsiFormat(new Attribute[]{Attribute.BOLD(), Attribute.ITALIC()})) + " ";
    private static Thread shellThread;

    public MineBootShell(MineBootEventHandler preInitTask) {
        super(moduleName, MineBootModuleType.ModuleType.BASIC, 1L);
        this.setModuleVersion(moduleVersion);
        this.preInitTaskEvent = preInitTask;
        pwdFile = new File(".");
        this.cliListener = new Scanner(System.in);
        shellThread = new Thread(() -> {
            System.out.println("\n");
            this.callInterpreter(this.getPrompt());
        });
        shellThread.setName("MineBootShell_MainThread");
    }

    private void callInterpreter(String prompt) {
        while (true) {
            System.out.print(prompt);
            String[] args = this.cliListener.nextLine().split(" ");
            this.sendCommand(args);
        }
    }

    private void sendCommand(String[] cmdName) {
        if (!cmdName[0].isEmpty()) {
            if (MineBootCommand.getCommands().get(cmdName[0]) == null) {
                System.err.println("\nCommand \"" + cmdName[0] + "\" not found !");
            } else {
                MineBootCommand command = MineBootCommand.getCommands().get(cmdName[0]);
                if (cmdName.length > 1) {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(cmdName));
                    list.remove(0);
                    command.setCommandArgs(list);
                }
                command.launchCommand();
            }
        }
    }

    public static File getPwdFile() {
        return pwdFile;
    }

    public void onDisable() {
        MineBootCommand.unregisterAllCommands();
        shellThread.stop();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public static void setPwdFile(File pwdFile) {
        MineBootShell.pwdFile = pwdFile;
    }

    public static boolean isCoreUtilsEnabled() {
        return coreUtilsEnabled;
    }

    public static void setCoreUtilsEnabled(boolean coreUtilsEnabled) {
        MineBootShell.coreUtilsEnabled = coreUtilsEnabled;
    }

    public void onEnable() {
        if (this.preInitTaskEvent != null) {
            this.preInitTaskEvent.onEvent();
        }
        MineBootCommand.registerCommand(new MineBootHelpCommand());
        MineBootCommand.registerCommand(new MineBootAboutShellInfoCommand());
        if (MineBootShell.isCoreUtilsEnabled()) {
            MineBootCommand.registerCommand(new MineBootPwdCommand());
            MineBootCommand.registerCommand(new MineBootCdCommand());
            MineBootCommand.registerCommand(new MineBootMkdirCommand());
            MineBootCommand.registerCommand(new MineBootRmCommand());
        }
        shellThread.start();
    }

    static {
        coreUtilsEnabled = false;
    }
}

